/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.event;

import com.geoway.vtile.commons.event.IListener;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EventContainer<T extends IListener> {
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<T>> eventMap = new ConcurrentHashMap();

    public void addListener(String eventName, T listener) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            queue = this.createQueue(eventName);
            this.eventMap.put(eventName, queue);
        }
        queue.add(listener);
    }

    private synchronized ConcurrentLinkedQueue<T> createQueue(String eventName) {
        ConcurrentLinkedQueue<Object> queue = this.eventMap.get(eventName);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue();
        }
        return queue;
    }

    public void un(String eventName, T listener) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            return;
        }
        queue.remove(listener);
    }

    public void syncFireEvent(String eventName, Object ... parameter) {
        ConcurrentLinkedQueue<T> queue = this.eventMap.get(eventName);
        if (queue == null) {
            return;
        }
        queue.forEach(listener -> listener.fire(parameter));
    }
}

