/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.type;

import com.geoway.vtile.exception.NotSupport;
import com.geoway.vtile.type.AbstractType;
import com.geoway.vtile.type.Type;
import com.geoway.vtile.type.Types;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.DateUtils;

public class TypeTimestamp
extends AbstractType
implements Type {
    public static final TypeTimestamp INSTANCE = new TypeTimestamp();

    public TypeTimestamp() {
        super(Types.TYPE_ENUM.Timestamp);
    }

    @Override
    public Class<?> getJavaClass() {
        return Date.class;
    }

    @Override
    public boolean isType(Object o) {
        if (o == null) {
            return false;
        }
        return o instanceof Date;
    }

    @Override
    public Object strToType(String str) {
        Date value;
        if (this.stringNull(str)) {
            return null;
        }
        try {
            value = DateUtils.parseDate((String)str, (Locale)Locale.CHINA, (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM"});
        }
        catch (ParseException e) {
            try {
                value = DateUtils.parseDate((String)str, (Locale)Locale.ENGLISH, (String[])new String[]{"yyyy-MM-dd h:mm:ss a"});
            }
            catch (ParseException ex) {
                throw new RuntimeException(str + "\u4e0d\u80fd\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b,\u65e5\u671f\u8f6c\u6362\u683c\u5f0f\u4e3a:'yyyy-MM-dd','yyyy-MM-dd HH:mm:ss','yyyy\u5e74MM\u6708dd\u65e5','yyyy-MM', 'yyyy-MM-dd h:mm:ss a'");
            }
        }
        return value;
    }

    public Object strToType(String str, String dateFormat) {
        if (this.stringNull(str)) {
            return null;
        }
        try {
            Date value = DateUtils.parseDate((String)str, (String[])new String[]{dateFormat});
            return value;
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException(str + "\u4e0d\u80fd\u8f6c\u6362\u6210\u65e5\u671f\u7c7b\u578b,\u65e5\u671f\u8f6c\u6362\u683c\u5f0f\u4e3a:" + dateFormat);
        }
    }

    public String valueToString(Object o, String dateFormat) {
        if (o == null) {
            return null;
        }
        SimpleDateFormat formatdate = new SimpleDateFormat(dateFormat);
        return formatdate.format(o);
    }

    @Override
    public String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        SimpleDateFormat formatdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return formatdate.format(o);
    }

    @Override
    public Object toType(Object o) {
        if (o == null) {
            return null;
        }
        if (this.isType(o)) {
            return o;
        }
        return this.strToType(o.toString());
    }

    @Override
    public Boolean isTypePrimitive(Object o) {
        return false;
    }

    @Override
    Object nativeChange(Object o) {
        throw new NotSupport();
    }

    @Override
    Object numberChange(Number o) {
        throw new NotSupport();
    }
}

