/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

public class LexerString {
    private char[] array;
    private int length;
    private int pos = 0;
    private String token;
    private int savePos = -1;

    public void lexer(String input) {
        this.array = input.toCharArray();
        this.length = this.array.length;
        this.pos = 0;
    }

    public void save() {
        this.savePos = this.pos;
    }

    public void restore() {
        if (this.savePos != -1) {
            this.pos = this.savePos;
            this.savePos = -1;
        }
    }

    public String token() {
        return this.token;
    }

    public String nextToken(char comma) {
        if (this.pos < this.length) {
            StringBuilder out = new StringBuilder(16);
            while (this.pos < this.length && this.array[this.pos] != comma) {
                out.append(this.array[this.pos]);
                ++this.pos;
            }
            ++this.pos;
            this.token = out.toString();
        } else {
            this.token = null;
        }
        return this.token;
    }

    public String nextTokenToQuote() {
        if (this.pos < this.length) {
            int commaCount = 1;
            StringBuilder out = new StringBuilder(16);
            while (this.pos != this.length - 1 && (this.array[this.pos + 1] != ' ' || commaCount % 2 != 1) || this.array[this.pos] != '\'') {
                if (this.array[this.pos] == '\'') {
                    ++commaCount;
                }
                out.append(this.array[this.pos]);
                ++this.pos;
            }
            ++this.pos;
            this.token = out.toString();
        } else {
            this.token = null;
        }
        return this.token;
    }

    public void skip(int skip) {
        this.pos += skip;
    }

    public char current() {
        return this.array[this.pos];
    }

    public boolean hasNext() {
        return this.pos < this.length;
    }
}

