/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class StringUtility {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static HashMap sqlTokens = new HashMap();
    public static Pattern p_n;
    public static Pattern p_function;

    private StringUtility() {
    }

    public static String getDataSize(long size) {
        DecimalFormat formater = new DecimalFormat("####.00");
        if (size < 1024L) {
            return size + "bytes";
        }
        if (size < 0x100000L) {
            float kbsize = (float)size / 1024.0f;
            return formater.format(kbsize) + "KB";
        }
        if (size < 0x40000000L) {
            float mbsize = (float)size / 1024.0f / 1024.0f;
            return formater.format(mbsize) + "MB";
        }
        float gbsize = (float)size / 1024.0f / 1024.0f / 1024.0f;
        return formater.format(gbsize) + "GB";
    }

    public static double DoubleValue(String str) {
        if (str != null && !str.equalsIgnoreCase("-")) {
            if (str.indexOf(37) > 0) {
                str = str.replaceAll("%", "");
            }
            return Double.parseDouble(str.trim());
        }
        return 0.0;
    }

    public static final String encodeSql(String oldString) {
        if (oldString == null) {
            return null;
        }
        Set tokensSet = sqlTokens.entrySet();
        for (Map.Entry entry : tokensSet) {
            oldString = StringUtility.replace(oldString, (String)entry.getKey(), (String)entry.getValue());
        }
        return oldString;
    }

    public static final String replace(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            int counter = 0;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            int counter = 0;
            ++counter;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String escapeHTMLTags(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch != '>') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(GT_ENCODE);
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final byte[] decodeHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCount = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringUtility.hexCharToByte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (byte)(newByte | StringUtility.hexCharToByte(chars[i + 1]));
            ++byteCount;
        }
        return bytes;
    }

    public static String filterNull(String str) {
        if (str == null) {
            return new String("");
        }
        return str;
    }

    public static String htmlNull(String str) {
        if (str == null || str.equals("")) {
            return new String("&nbsp;");
        }
        return str;
    }

    public static String htmlNull(Integer i) {
        if (i == null) {
            return new String("&nbsp;");
        }
        return i.toString();
    }

    private static final byte hexCharToByte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return null;
        }
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String formatYearMonth(String _yearMonth) {
        return _yearMonth.substring(0, 4) + "\u5e74" + _yearMonth.substring(4) + "\u6708";
    }

    public static boolean isNullOrBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String null2Str(Object objIn) {
        return objIn == null ? "&nbsp;" : String.valueOf(objIn);
    }

    public static String nvl(String str, String re) {
        if (str != null && !str.equals("")) {
            return str;
        }
        return re;
    }

    public static String formatBillNo(String id) {
        Integer iPk = Integer.valueOf(id);
        int cont = 100000000;
        int temp = cont + iPk;
        String iStr = String.valueOf(temp);
        iStr = iStr.substring(1);
        return "N" + iStr;
    }

    public static String toUTF(String src) {
        byte[] tmp = new byte[src.length() >> 1];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (byte)Integer.parseInt(src.substring(i * 2, i * 2 + 2), 16);
        }
        try {
            return new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String initialUpper(String str) {
        StringBuffer sb = new StringBuffer();
        char[] words = str.toCharArray();
        int prevc = 32;
        for (int n : words) {
            if (n != 32 && prevc == 32) {
                sb.append(Character.toUpperCase((char)n));
            } else {
                sb.append(Character.toLowerCase((char)n));
            }
            prevc = n;
        }
        return sb.toString();
    }

    public static String pathString(String str) {
        StringBuffer strBuf = new StringBuffer();
        int temp = 0;
        strBuf.append(str.substring(0, 1));
        for (int i = 1; i < str.length(); ++i) {
            ++temp;
            strBuf.append("\\");
            if (i == str.length()) {
                strBuf.append(str.substring(0, str.length()));
            } else if (temp == 4) {
                strBuf.append(str.substring(0, i + 3));
                ++i;
            } else {
                strBuf.append(str.substring(0, i + 2));
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static String splitPathString(String str) {
        StringBuffer strBuf = new StringBuffer();
        int temp = 0;
        strBuf.append(str.substring(0, 1));
        for (int i = 1; i < str.length(); ++i) {
            ++temp;
            strBuf.append(",");
            if (i == str.length()) {
                strBuf.append(str.substring(0, str.length()));
            } else if (temp == 4) {
                strBuf.append(str.substring(0, i + 3));
                ++i;
            } else {
                strBuf.append(str.substring(0, i + 2));
            }
            ++i;
        }
        return strBuf.toString();
    }

    public static int numberOfStr(String str, String subStr) {
        if (str.endsWith(subStr)) {
            return str.split(subStr).length;
        }
        return str.split(subStr).length - 1;
    }

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");
        return uuid;
    }

    public static String delBlank(String str) {
        Matcher m = p_n.matcher(str);
        String after = m.replaceAll("");
        return after;
    }

    public static Boolean equals(String a1, String a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null) {
            return a1.equals(a2);
        }
        if (a2 != null) {
            return a2.equals(a1);
        }
        return false;
    }

    public static Boolean equalsIgnoreCase(String a1, String a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 != null) {
            return a1.equalsIgnoreCase(a2);
        }
        if (a2 != null) {
            return a2.equalsIgnoreCase(a1);
        }
        return false;
    }

    public static Integer indexOf(String a1, String a2) {
        if (a1 == null || a2 == null) {
            return null;
        }
        return a1.indexOf(a2);
    }

    public static Boolean isFunction(String s) {
        Matcher matcher = p_function.matcher(s);
        return matcher.find();
    }

    public static String[] getFunctionInfo(String s) {
        char mark;
        int index;
        StringBuffer sb = new StringBuffer(s);
        int cutBeginIndex = -1;
        int cutEndIndex = -1;
        for (index = 0; index < sb.length(); ++index) {
            mark = sb.charAt(index);
            if (mark != '(') continue;
            cutBeginIndex = index;
            break;
        }
        if (cutBeginIndex == -1) {
            return null;
        }
        for (index = sb.length() - 1; index > 0; --index) {
            mark = sb.charAt(index);
            if (mark != ')') continue;
            cutEndIndex = index;
            break;
        }
        String[] info = new String[2];
        String functionName = s.substring(0, cutBeginIndex).trim();
        String parms = s.substring(cutBeginIndex + 1, cutEndIndex);
        info[0] = functionName;
        info[1] = parms;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clobToString(Clob clob) {
        if (clob == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Reader clobStream = null;
        try {
            clobStream = clob.getCharacterStream();
            char[] b = new char[60000];
            int i = 0;
            while ((i = clobStream.read(b)) != -1) {
                sb.append(b, 0, i);
            }
        }
        catch (Exception ex) {
            sb = null;
        }
        finally {
            try {
                if (clobStream != null) {
                    clobStream.close();
                }
            }
            catch (Exception exception) {}
        }
        if (sb == null) {
            return null;
        }
        return sb.toString();
    }

    public static Clob stringToClob(String str) throws SerialException, SQLException {
        SerialClob c = new SerialClob(str.toCharArray());
        return c;
    }

    public static Geometry stringToGeometry(String value) {
        WKTReader fromText = new WKTReader();
        Geometry geometry = null;
        try {
            geometry = fromText.read(value);
        }
        catch (ParseException e) {
            return null;
        }
        return geometry;
    }

    public static String changeHtm(String changeHtmlValue) {
        StringBuffer sb = new StringBuffer(changeHtmlValue);
        char[] code = changeHtmlValue.toCharArray();
        int length = sb.length();
        char[] newcode = new char[length * 5];
        int index = 0;
        int codeIndex = 0;
        int newcodeIndex = 0;
        int copyLenght = 0;
        while (index < length) {
            char indexChar = sb.charAt(index);
            char[][] replacement = StringUtility.getReplacement(code, index);
            if (replacement != null) {
                char[] ori = replacement[0];
                int oriLength = ori.length;
                char[] target = replacement[1];
                int targetLength = target.length;
                char previous = sb.charAt(index - 1);
                if (previous == '\\' && oriLength <= 1) continue;
                if (copyLenght != 0) {
                    System.arraycopy(code, codeIndex, newcode, newcodeIndex, copyLenght);
                    newcodeIndex += copyLenght;
                    codeIndex += copyLenght;
                }
                System.arraycopy(target, 0, newcode, newcodeIndex, targetLength);
                codeIndex += oriLength;
                newcodeIndex += targetLength;
                index += oriLength;
                copyLenght = 0;
                continue;
            }
            ++copyLenght;
            ++index;
        }
        if (codeIndex == 0) {
            return changeHtmlValue;
        }
        if (copyLenght != 0) {
            System.arraycopy(code, codeIndex, newcode, newcodeIndex, copyLenght);
            newcodeIndex += copyLenght;
        }
        char[] returnCode = new char[newcodeIndex];
        System.arraycopy(newcode, 0, returnCode, 0, newcodeIndex);
        return String.valueOf(returnCode);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    private static char[][] getReplacement(char[] code, int index) {
        char[][] symbol = new char[][]{{'\r'}, {'<', 'b', 'r', '/', '>'}, {'\n'}, {'<', 'b', 'r', '/', '>'}, {'\t'}, {' '}, {'\"'}, {'\\', '\\', '\\', '\"'}, {'\\'}, {'\\', '\\', '\\', '\\'}};
        char[] ori = null;
        char[] target = null;
        int deep = -1;
        int length = 0;
        int codeIndex = 0;
        for (int i = 0; i < symbol.length; i += 2) {
            codeIndex = index;
            deep = -1;
            ori = symbol[i];
            target = symbol[i + 1];
            length = ori.length;
            while (deep + 1 < length && code[codeIndex] == ori[deep + 1]) {
                ++codeIndex;
                ++deep;
            }
            if (deep != length - 1) continue;
            return new char[][]{symbol[i], symbol[i + 1]};
        }
        return null;
    }

    public static void main(String[] aaa) {
        System.out.print(StringUtility.getFunctionInfo("objectid"));
    }

    static {
        sqlTokens.put("'", "''");
        p_n = Pattern.compile("\n");
        p_function = Pattern.compile("\\(([^\\(]+)\\)");
    }
}

