/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.collection.builder;

import com.geoway.vtile.commons.collection.builder.AbstractBuilder;
import com.geoway.vtile.commons.collection.builder.Builder;
import com.geoway.vtile.commons.util.UnsafeFuntion;
import java.nio.ByteBuffer;

public class DoubleBuilder
extends AbstractBuilder<double[]>
implements Builder<double[]> {
    public DoubleBuilder() {
    }

    public DoubleBuilder(double[] arr) {
        super(arr);
    }

    public DoubleBuilder(int size) {
        super(size);
    }

    public double get(int index) {
        if (this.isDirect.booleanValue()) {
            this.getClass();
            int dataBlockIndex = (index *= this.typeSize) / 0x100000;
            this.getClass();
            int dbbIndex = index % 0x100000;
            return ((ByteBuffer)this.directBufferArr.get(dataBlockIndex)).getDouble(dbbIndex);
        }
        return ((double[])this.heap)[index];
    }

    public DoubleBuilder append(double[] arr) {
        return (DoubleBuilder)super.append(arr, 0, arr.length);
    }

    public DoubleBuilder append(double d) {
        int off = 1;
        if (this.size + off > this.capacity) {
            this.ensureCapacityInternal(1);
        }
        if (this.isDirect.booleanValue()) {
            this.currentDirectByteBuffer.putDouble(d);
        } else {
            ((double[])this.heap)[this.size] = d;
        }
        ++this.size;
        return this;
    }

    public DoubleBuilder append(double[] arr, int offset, int length) {
        return (DoubleBuilder)super.append(arr, offset, length);
    }

    public void set(int index, double d) {
        if (index >= this.size) {
            throw new RuntimeException("out of range");
        }
        if (this.isDirect.booleanValue()) {
            this.getClass();
            int dataBlockIndex = (index *= this.typeSize) / 0x100000;
            this.getClass();
            int dbbIndex = index % 0x100000;
            ((ByteBuffer)this.directBufferArr.get(dataBlockIndex)).putDouble(dbbIndex, d);
        } else {
            ((double[])this.heap)[index] = d;
        }
    }

    @Override
    double[] createHeap(int size) {
        return new double[size];
    }

    @Override
    protected long getHeapTypeOffset() {
        return UnsafeFuntion.doubleArrayOffset;
    }

    @Override
    protected int getHeapTypeOff() {
        return 3;
    }

    @Override
    protected int getHeapSize(double[] heap) {
        return heap.length;
    }

    @Override
    int getTypeSize() {
        return 8;
    }
}

