/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.collection.builder;

import com.geoway.vtile.commons.util.UnsafeFuntion;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import sun.nio.ch.DirectBuffer;

public abstract class AbstractBuilder<HEAP_TYPE> {
    protected final int beginSize = 2048;
    protected int expansionHeapTimes = 1;
    protected final int directApplySize = 0x100000;
    protected HEAP_TYPE heap;
    protected int capacity;
    protected int size;
    protected Boolean isDirect = false;
    protected int typeSize = this.getTypeSize();
    protected int directApplySizeNum;
    protected ArrayList<ByteBuffer> directBufferArr;
    protected ByteBuffer currentDirectByteBuffer = null;
    private static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    abstract HEAP_TYPE createHeap(int var1);

    public AbstractBuilder() {
        this.capacity = this.beginSize / this.typeSize;
        this.heap = this.createHeap(this.capacity);
        this.directApplySizeNum = 0x100000 / this.typeSize;
    }

    abstract int getTypeSize();

    public AbstractBuilder(HEAP_TYPE arr) {
        this();
        this.append(arr, 0, this.getHeapSize(arr));
    }

    public AbstractBuilder(int size) {
        this.capacity = size;
        if (this.directApplySizeNum > size) {
            this.heap = this.createHeap(size);
        } else {
            this.isDirect = true;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size * this.typeSize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer)((Object)byteBuffer);
            db.cleaner().clean();
        }
    }

    public Boolean isDirect() {
        return this.isDirect;
    }

    public int size() {
        return this.size;
    }

    private void expansionInHeap(int arrSize) {
        int applySize = this.beginSize * this.expansionHeapTimes / this.typeSize;
        ++this.expansionHeapTimes;
        int newSize = applySize > arrSize ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
        HEAP_TYPE newHeap = this.createHeap(newSize);
        System.arraycopy(this.heap, 0, newHeap, 0, this.size);
        this.heap = newHeap;
        this.capacity = newSize;
    }

    private void expansionInDirect(int size) {
        if (size > this.directApplySizeNum) {
            int times = size / this.directApplySizeNum + 1;
            int newCapacity = this.directApplySizeNum * times;
            while (times-- > 0) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(newBuffer);
            }
            this.capacity = newCapacity;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity += this.directApplySizeNum;
        }
    }

    protected ByteBuffer getByteBuffer(int index) {
        return this.directBufferArr.get(index /= this.directApplySize);
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    protected void putArrIntoDirectByteBuffer(ByteBuffer buffer, Object arr, int offset, int length) {
        if (nativeOrder != ByteOrder.LITTLE_ENDIAN) {
            throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301\u5927\u7aef");
        }
        this.putArrIntoDirectByteBufferL(buffer, arr, offset, length);
    }

    protected void putArrIntoDirectByteBufferL(ByteBuffer buffer, Object arr, int offset, int length) {
        int rem;
        if (!(buffer instanceof DirectBuffer)) {
            throw new RuntimeException("buffer\u5fc5\u987b\u662fDirectBuffer");
        }
        int pos = buffer.position() / this.typeSize;
        int lim = buffer.limit() / this.typeSize;
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (length > rem) {
            throw new BufferOverflowException();
        }
        DirectBuffer directBuffer = (DirectBuffer)((Object)buffer);
        int off = this.getHeapTypeOff();
        long dstAddr = directBuffer.address() + ((long)pos << off);
        try {
            if (this.order() != ByteOrder.nativeOrder()) {
                UnsafeFuntion.get().copyFromLongArray(arr, (long)offset << off, dstAddr, (long)length << off);
            } else {
                UnsafeFuntion.get().copyFromArray(arr, this.getHeapTypeOffset(), (long)offset << off, dstAddr, (long)length << off);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        buffer.position((pos + length) * this.typeSize);
    }

    protected abstract long getHeapTypeOffset();

    protected abstract int getHeapTypeOff();

    protected abstract int getHeapSize(HEAP_TYPE var1);

    private void toDirect(int size) {
        this.isDirect = true;
        int newSize = this.directApplySize;
        this.directBufferArr = new ArrayList();
        if ((size + this.capacity) * this.typeSize > this.directApplySize) {
            int times = (size + this.capacity) * this.typeSize / this.directApplySize + 1;
            int copyDone = 0;
            int newCapacity = this.directApplySize / this.typeSize * times;
            while (times-- > 0) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(byteBuffer);
                int directByteBufferSize = this.directApplySize / this.typeSize;
                if (copyDone < this.size) {
                    if (this.size > directByteBufferSize) {
                        this.putArrIntoDirectByteBuffer(byteBuffer, this.heap, copyDone, directByteBufferSize);
                    } else {
                        if (this.getHeapSize(this.heap) - copyDone != 0) {
                            this.putArrIntoDirectByteBuffer(byteBuffer, this.heap, copyDone, this.size - copyDone);
                        }
                        this.currentDirectByteBuffer = byteBuffer;
                    }
                }
                copyDone += directByteBufferSize;
            }
            this.capacity = newCapacity;
        } else {
            this.capacity = this.directApplySize / this.typeSize;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity = newSize / this.typeSize;
            this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
        }
    }

    public void trimToSize() {
        if (!this.isDirect.booleanValue()) {
            HEAP_TYPE newHeap = this.createHeap(this.size);
            System.arraycopy(this.heap, 0, newHeap, 0, this.size);
            this.heap = newHeap;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
            this.currentDirectByteBuffer.flip();
            newBuffer.put(this.currentDirectByteBuffer);
            DirectBuffer db = (DirectBuffer)((Object)this.currentDirectByteBuffer);
            db.cleaner().clean();
            this.directBufferArr.set(this.directBufferArr.size() - 1, newBuffer);
            this.currentDirectByteBuffer = newBuffer;
        }
    }

    public void destroy() {
        if (this.isDirect.booleanValue()) {
            for (ByteBuffer bf : this.directBufferArr) {
                this.clean(bf);
            }
        }
    }

    protected void ensureCapacityInternal(int size) {
        if (!this.isDirect.booleanValue()) {
            if ((this.capacity + size) * this.typeSize + this.beginSize * this.expansionHeapTimes > this.directApplySize) {
                this.toDirect(size);
            } else {
                this.expansionInHeap(size);
            }
        } else {
            this.expansionInDirect(size);
        }
    }

    public AbstractBuilder<HEAP_TYPE> append(HEAP_TYPE arr, int offset, int length) {
        if (arr == null) {
            return this;
        }
        if (this.capacity <= length - offset + this.size) {
            this.ensureCapacityInternal(length - offset);
        }
        if (this.isDirect.booleanValue()) {
            int beginBlockIndex = this.size / this.directApplySizeNum;
            int beginSubIndex = this.size % this.directApplySizeNum;
            int endBlockIndex = (length - offset + this.size) / this.directApplySizeNum + 1;
            int copyDone = 0;
            for (int i = beginBlockIndex; i < endBlockIndex; ++i) {
                int copyLength = this.directApplySizeNum;
                ByteBuffer dbb = null;
                try {
                    dbb = this.directBufferArr.get(i);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (i == beginBlockIndex) {
                    copyLength = this.directApplySizeNum - beginSubIndex;
                }
                if (i == endBlockIndex - 1) {
                    copyLength = length - offset - copyDone;
                }
                this.putArrIntoDirectByteBuffer(dbb, arr, copyDone, copyLength);
                copyDone += copyLength;
            }
        } else {
            System.arraycopy(arr, offset, this.heap, this.size, length - offset);
        }
        this.size = this.size + length - offset;
        return this;
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[size=");
        sb.append(this.size);
        sb.append(" cap=");
        sb.append(this.capacity);
        sb.append("]");
        return sb.toString();
    }

    public AbstractBuilder<HEAP_TYPE> delete(int start, int end) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    public AbstractBuilder<HEAP_TYPE> deleteAt(int index) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    public HEAP_TYPE toArray() {
        if (this.isDirect.booleanValue()) {
            throw new RuntimeException("\u6682\u65f6\u4e0d\u652f\u6301");
        }
        return this.heap;
    }

    public void reset() {
        this.size = 0;
        this.capacity = this.beginSize / this.typeSize;
        if (this.isDirect.booleanValue()) {
            for (ByteBuffer bf : this.directBufferArr) {
                this.clean(bf);
            }
            this.directBufferArr = new ArrayList();
            this.isDirect = false;
        }
    }
}

