/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.resmple;

import com.geoway.vtile.commons.bits.UNumber;
import com.geoway.vtile.resmple.Fn1DResamplingFunction;
import java.nio.ByteBuffer;

public class Resample1DBicubic
implements Fn1DResamplingFunction {
    public static final Resample1DBicubic INSTANCE = new Resample1DBicubic();
    static final double B = 0.0;
    static final double C = 0.5;
    static final byte b0 = 0;

    double getBicubicWeight(double x) {
        if ((x = Math.abs(x)) < 1.0) {
            return ((9.0 * x + -15.0) * x * x + 6.0 - 0.0) / 6.0;
        }
        if (x < 2.0) {
            return (-3.0 * x + 15.0 * x - 24.0 * x + 0.0 + 12.0) / 6.0;
        }
        return 0.0;
    }

    @Override
    public void resampling(ByteBuffer dstBuffer, int dstInitialOffset, int numDstPixels, int dstPixelStride, ByteBuffer srcBuffer, int srcInitialOffset, int numSrcPixels, int srcPixelStride, int numBytesPerPixel) {
        int dstPixelOffsetInBuffer = dstInitialOffset;
        int accumulator = 0;
        for (int dstPixelIndex = 0; dstPixelIndex < numDstPixels; ++dstPixelIndex) {
            int dstPixelIndexInSrcSpace;
            int srcPixelIndex = dstPixelIndexInSrcSpace = accumulator / numDstPixels;
            int firstSrcPixelIndex = Math.max(srcPixelIndex - 1, 0);
            int lastSrcPixelIndex = Math.min(srcPixelIndex + 2, numSrcPixels - 1);
            double accumulator3 = 0.0;
            double accumulator2 = 0.0;
            double accumulator1 = 0.0;
            double accumulator0 = 0.0;
            int totalWeight = 0;
            int srcPixelOffsetInBuffer = firstSrcPixelIndex * srcPixelStride + srcInitialOffset;
            for (int srcPixelIndexInRun = firstSrcPixelIndex; srcPixelIndexInRun <= lastSrcPixelIndex; ++srcPixelIndexInRun) {
                double srcPixelWeight = this.getBicubicWeight((srcPixelIndex - dstPixelIndexInSrcSpace) * numDstPixels / numSrcPixels);
                switch (numBytesPerPixel) {
                    case 4: {
                        accumulator3 += (double)UNumber.getUint8(srcBuffer, srcPixelOffsetInBuffer + 3) * srcPixelWeight;
                    }
                    case 3: {
                        accumulator2 += (double)UNumber.getUint8(srcBuffer, srcPixelOffsetInBuffer + 2) * srcPixelWeight;
                        accumulator1 += (double)UNumber.getUint8(srcBuffer, srcPixelOffsetInBuffer + 1) * srcPixelWeight;
                    }
                    case 1: {
                        accumulator0 += (double)UNumber.getUint8(srcBuffer, srcPixelOffsetInBuffer + 0) * srcPixelWeight;
                    }
                }
                totalWeight = (int)((double)totalWeight + srcPixelWeight);
                srcPixelOffsetInBuffer += srcPixelStride;
            }
            if (totalWeight > 0) {
                switch (numBytesPerPixel) {
                    case 4: {
                        dstBuffer.put(dstPixelOffsetInBuffer + 3, (byte)(accumulator3 / (double)totalWeight));
                    }
                    case 3: {
                        dstBuffer.put(dstPixelOffsetInBuffer + 2, (byte)(accumulator2 / (double)totalWeight));
                        dstBuffer.put(dstPixelOffsetInBuffer + 1, (byte)(accumulator1 / (double)totalWeight));
                    }
                    case 1: {
                        dstBuffer.put(dstPixelOffsetInBuffer, (byte)(accumulator0 / (double)totalWeight));
                    }
                }
            } else {
                switch (numBytesPerPixel) {
                    case 4: {
                        dstBuffer.put(dstPixelOffsetInBuffer + 3, (byte)0);
                    }
                    case 3: {
                        dstBuffer.put(dstPixelOffsetInBuffer + 2, (byte)0);
                        dstBuffer.put(dstPixelOffsetInBuffer + 1, (byte)0);
                    }
                    case 1: {
                        dstBuffer.put(dstPixelOffsetInBuffer, (byte)0);
                    }
                }
            }
            dstPixelOffsetInBuffer += dstPixelStride;
            accumulator += numSrcPixels;
        }
    }
}

