/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, len);
        return len;
    }

    public byte[] toBytes() {
        this.buf.flip();
        int len = this.buf.limit() - this.buf.position();
        byte[] bytes1 = new byte[len];
        this.buf.get(bytes1);
        return bytes1;
    }
}

