/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.javacode.compiler;

import com.geoway.vtile.commons.classloader.MemoryClassLoader;
import com.geoway.vtile.commons.javacode.compiler.CompilationException;
import com.geoway.vtile.commons.javacode.compiler.CompiledCode;
import com.geoway.vtile.commons.javacode.compiler.ExtendedStandardJavaFileManager;
import com.geoway.vtile.commons.javacode.compiler.SourceCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class JavaCompiler {
    private javax.tools.JavaCompiler javac;
    private MemoryClassLoader classLoader;
    private Iterable<String> options;
    boolean ignoreWarnings = false;
    private Map<String, SourceCode> sourceCodes = new HashMap<String, SourceCode>();

    public static JavaCompiler newInstance() {
        return new JavaCompiler();
    }

    private JavaCompiler() {
        this.javac = ToolProvider.getSystemJavaCompiler();
        this.classLoader = new MemoryClassLoader(ClassLoader.getSystemClassLoader());
    }

    public JavaCompiler useParentClassLoader(ClassLoader parent) {
        this.classLoader = new MemoryClassLoader(parent);
        return this;
    }

    public ClassLoader getClassloader() {
        return this.classLoader;
    }

    public JavaCompiler useOptions(String ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public JavaCompiler ignoreWarnings() {
        this.ignoreWarnings = true;
        return this;
    }

    public Map<String, CompiledCode> compileAll() throws Exception {
        if (this.sourceCodes.size() == 0) {
            throw new CompilationException("No source code to compile");
        }
        Collection<SourceCode> compilationUnits = this.sourceCodes.values();
        CompiledCode[] code = new CompiledCode[compilationUnits.size()];
        Iterator<SourceCode> iter = compilationUnits.iterator();
        for (int i = 0; i < code.length; ++i) {
            code[i] = new CompiledCode(iter.next().getClassName());
        }
        DiagnosticCollector collector = new DiagnosticCollector();
        ExtendedStandardJavaFileManager fileManager = new ExtendedStandardJavaFileManager(this.javac.getStandardFileManager(null, null, null), this.classLoader);
        JavaCompiler.CompilationTask task = this.javac.getTask(null, fileManager, collector, this.options, null, compilationUnits);
        boolean result = task.call();
        if (!result || collector.getDiagnostics().size() > 0) {
            StringBuffer exceptionMsg = new StringBuffer();
            exceptionMsg.append("Unable to compile the source");
            boolean hasWarnings = false;
            boolean hasErrors = false;
            for (Diagnostic d : collector.getDiagnostics()) {
                switch (d.getKind()) {
                    case NOTE: 
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        hasWarnings = true;
                        break;
                    }
                    default: {
                        hasErrors = true;
                    }
                }
                exceptionMsg.append("\n").append("[kind=").append((Object)d.getKind());
                exceptionMsg.append(", ").append("line=").append(d.getLineNumber());
                exceptionMsg.append(", ").append("message=").append(d.getMessage(Locale.US)).append("]");
            }
            if (hasWarnings && !this.ignoreWarnings || hasErrors) {
                throw new CompilationException(exceptionMsg.toString());
            }
        }
        List<CompiledCode> compiledCodeList = fileManager.getCompiledCodeList();
        HashMap<String, CompiledCode> map = new HashMap<String, CompiledCode>();
        for (CompiledCode compiledCode : compiledCodeList) {
            map.put(compiledCode.getClassName(), compiledCode);
        }
        return map;
    }

    public CompiledCode compile(String className, String sourceCode) throws Exception {
        return this.addSource(className, sourceCode).compileAll().get(className);
    }

    public JavaCompiler addSource(String className, String sourceCode) throws Exception {
        this.sourceCodes.put(className, new SourceCode(className, sourceCode));
        return this;
    }
}

