/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.grid;

import com.geoway.vtile.spatial.Point;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.Lod;
import com.geoway.vtile.spatial.grid.impl.AbstractGrid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomGrid
extends AbstractGrid {
    Point originPoint;
    Map<Integer, Lod> levels = new HashMap<Integer, Lod>();

    public CustomGrid(int base, Constants.GRID_UNIT unit, List<Lod> lods, Point originPoint, Point endPoint) {
        this.unit = unit;
        this.base = base;
        this.originPoint = originPoint;
        if (unit == Constants.GRID_UNIT.pixel) {
            this.minX = (int)originPoint.x;
            this.minY = (int)originPoint.y;
            if (endPoint != null) {
                this.maxX = endPoint.x;
                this.maxY = endPoint.y;
            }
        } else {
            this.minX = originPoint.x;
            this.maxY = originPoint.y;
            if (endPoint != null) {
                this.maxX = endPoint.x;
                this.minY = endPoint.y;
            }
        }
        this._init(lods);
    }

    private void _init(List<Lod> lods) {
        lods.sort((o1, o2) -> o1.level - o2.level);
        this.beginLevel = lods.get((int)0).level;
        this.maxLevel = lods.get((int)(lods.size() - 1)).level;
        lods.stream().forEach(lod -> this.levels.put(lod.level, (Lod)lod));
    }

    @Override
    public Double getResolution(int level) {
        Lod lod = this.levels.get(level);
        if (lod == null) {
            return null;
        }
        return lod.resolution;
    }
}

