/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.diagnose;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;

@Plugin(name="ThreadFilter", category="Core", elementType="filter", printObject=true)
public class ThreadFilter
extends AbstractFilter {
    private String threadName;
    private Filter.Result onMatch;
    private Filter.Result onMisMatch;

    public ThreadFilter(String threadName, Filter.Result onMatch, Filter.Result onMisMatch) {
        this.threadName = threadName;
        this.onMatch = onMatch;
        this.onMisMatch = onMisMatch;
    }

    @PluginFactory
    public static ThreadFilter createFilter(@PluginAttribute(value="threadName") String threadName, @PluginAttribute(value="onMatch") Filter.Result match, @PluginAttribute(value="onMismatch") Filter.Result mismatch) {
        assert (StringUtils.isNotBlank((CharSequence)threadName));
        Filter.Result onMatch = match == null ? Filter.Result.NEUTRAL : match;
        Filter.Result onMismatch = mismatch == null ? Filter.Result.DENY : mismatch;
        return new ThreadFilter(threadName, onMatch, onMismatch);
    }

    public Filter.Result filter(LogEvent event) {
        if (event.getThreadName().startsWith(this.threadName)) {
            return this.onMatch;
        }
        return this.onMisMatch;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
        return super.filter(logger, level, marker, msg, t);
    }
}

