/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.bits;

import com.geoway.vtile.commons.bits.Bites;
import java.nio.ByteBuffer;

public class HexUtils {
    private static char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static byte[] stringToHex(String s) {
        StringBuilder sb = new StringBuilder();
        byte[] bs = s.getBytes();
        for (int i = 0; i < bs.length; ++i) {
            int bit = (bs[i] & 0xF0) >> 4;
            sb.append(hexArray[bit]);
            bit = bs[i] & 0xF;
            sb.append(hexArray[bit]);
        }
        return HexUtils.hexStringToBytes(sb.toString().trim());
    }

    public static String hexStringToString(String hexStr) {
        hexStr = hexStr.toUpperCase();
        String str = "0123456789ABCDEF";
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int n = str.indexOf(hexs[2 * i]) * 16;
            bytes[i] = (byte)((n += str.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static byte[] hexStringToByteArray(String s) {
        if (s.length() < 2) {
            s = "0" + s;
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String bytesToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] bytesToHexStringByte(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = (byte)hexArray[v >>> 4];
            hexChars[j * 2 + 1] = (byte)hexArray[v & 0xF];
        }
        return hexChars;
    }

    public static void putHexByte(int offset, ByteBuffer buffer, byte b) {
        int v = b & 0xFF;
        buffer.put(offset * 2, (byte)hexArray[v >>> 4]);
        buffer.put(offset * 2 + 1, (byte)hexArray[v & 0xF]);
    }

    public static void putIntHexByte(int offset, ByteBuffer buffer, int i, boolean bigEndian) {
        if (bigEndian) {
            HexUtils.putHexByte(offset, buffer, Bites.int3(i));
            HexUtils.putHexByte(offset + 1, buffer, Bites.int2(i));
            HexUtils.putHexByte(offset + 2, buffer, Bites.int1(i));
            HexUtils.putHexByte(offset + 3, buffer, Bites.int0(i));
        } else {
            HexUtils.putHexByte(offset + 3, buffer, Bites.int3(i));
            HexUtils.putHexByte(offset + 2, buffer, Bites.int3(i));
            HexUtils.putHexByte(offset + 1, buffer, Bites.int3(i));
            HexUtils.putHexByte(offset, buffer, Bites.int3(i));
        }
    }

    public static void putLongHexByte(int offset, ByteBuffer buffer, long x, boolean bigEndian) {
        if (bigEndian) {
            HexUtils.putHexByte(offset, buffer, Bites.long7(x));
            HexUtils.putHexByte(offset + 1, buffer, Bites.long6(x));
            HexUtils.putHexByte(offset + 2, buffer, Bites.long5(x));
            HexUtils.putHexByte(offset + 3, buffer, Bites.long4(x));
            HexUtils.putHexByte(offset + 4, buffer, Bites.long3(x));
            HexUtils.putHexByte(offset + 5, buffer, Bites.long2(x));
            HexUtils.putHexByte(offset + 6, buffer, Bites.long1(x));
            HexUtils.putHexByte(offset + 7, buffer, Bites.long0(x));
        } else {
            HexUtils.putHexByte(offset + 7, buffer, Bites.long7(x));
            HexUtils.putHexByte(offset + 6, buffer, Bites.long6(x));
            HexUtils.putHexByte(offset + 5, buffer, Bites.long5(x));
            HexUtils.putHexByte(offset + 4, buffer, Bites.long4(x));
            HexUtils.putHexByte(offset + 3, buffer, Bites.long3(x));
            HexUtils.putHexByte(offset + 2, buffer, Bites.long2(x));
            HexUtils.putHexByte(offset + 1, buffer, Bites.long1(x));
            HexUtils.putHexByte(offset, buffer, Bites.long0(x));
        }
    }

    public static void putDoubleHexByte(int offset, ByteBuffer buffer, double x, boolean bigEndian) {
        long l = Double.doubleToRawLongBits(x);
        HexUtils.putLongHexByte(offset, buffer, l, bigEndian);
    }

    public static int hexStringToInt(String hexString) {
        return Integer.parseInt(hexString, 16);
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(HexUtils.charToByte(hexChars[pos]) << 4 | HexUtils.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

