/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.grid.impl.quadtreegrid;

import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.impl.GridName;
import com.geoway.vtile.spatial.grid.impl.QuadtreeImpl;

@GridName(name="esri_degrees_base512")
public class EsriDegrees512
extends QuadtreeImpl {
    double[] resolution;

    public EsriDegrees512() {
        this.init(512, 2, Constants.GRID_UNIT.degree);
    }

    public EsriDegrees512(int minX, int maxY, double[] resolution) {
        this.init(512, 2, Constants.GRID_UNIT.degree);
    }

    @Override
    protected void init(Integer base, int beginLevel, Constants.GRID_UNIT unit) {
        this.base = base;
        this.unit = unit;
        this.minX = -400.0;
        this.minY = -90.0;
        this.maxX = 180.0;
        this.maxY = 400.0;
        this.beginLevel = beginLevel;
    }

    @Override
    public Double getResolution(int level) {
        if (level >= this.resolution.length || level < 0) {
            return this.resolution[0] / Math.pow(2.0, level);
        }
        return this.resolution[level];
    }

    @Override
    public void setResolutions(double[] resolution) {
        this.resolution = resolution;
    }

    @Override
    public double[] getResolutions() {
        return this.resolution;
    }
}

