/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.wkt;

import com.geoway.vtile.spatial.AGeomEncoder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.GeomEncoder;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import java.nio.ByteOrder;

@AGeomEncoder(type=Constants.SPATIAL_TYPE.wkt)
public class WktEncoder
implements GeomEncoder<String> {
    public static final WktEncoder ENCODER = new WktEncoder();

    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer) {
        return this.fromGeoBuffer(geoBuffer, true, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public String fromGeoBuffer(GeoBuffer geoBuffer, boolean includeSrid, ByteOrder byteOrder) {
        String wkt = geoBuffer.toJTSGeometry().toString();
        if (includeSrid) {
            int srid = geoBuffer.getSRID();
            if (srid == 0) {
                return wkt;
            }
            return "SRID=" + srid + ";" + wkt;
        }
        return wkt;
    }
}

