/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.type;

import com.geoway.vtile.type.Type;
import com.geoway.vtile.type.TypeAny;
import com.geoway.vtile.type.TypeBigDecimal;
import com.geoway.vtile.type.TypeBoolean;
import com.geoway.vtile.type.TypeBytes;
import com.geoway.vtile.type.TypeDouble;
import com.geoway.vtile.type.TypeInteger;
import com.geoway.vtile.type.TypeLong;
import com.geoway.vtile.type.TypeManager;
import com.geoway.vtile.type.TypeNotFindException;
import com.geoway.vtile.type.TypeString;
import com.geoway.vtile.type.TypeTimestamp;
import com.geoway.vtile.type.TypeUnknown;
import com.geoway.vtile.type.TypeVoid;
import java.util.Optional;

public interface Types {
    public static final TypeVoid VOID = TypeVoid.INSTANCE;
    public static final TypeUnknown UNKNOWN = TypeUnknown.INSTANCE;
    public static final TypeTimestamp TIME_STAMP = TypeTimestamp.INSTANCE;
    public static final TypeString STRING = TypeString.INSTANCE;
    public static final TypeLong LONG = TypeLong.INSTANCE;
    public static final TypeInteger INTEGER = TypeInteger.INSTANCE;
    public static final TypeDouble DOUBLE = TypeDouble.INSTANCE;
    public static final TypeBigDecimal BIGDECIMAL = TypeBigDecimal.INSTANCE;
    public static final TypeBoolean BOOLEAN = TypeBoolean.INSTANCE;
    public static final TypeBytes BYTES = TypeBytes.INSTANCE;
    public static final Type ANY = TypeAny.INSTANCE;

    public static Type isNumber(Object o) {
        Type type = Types.getType(o);
        if (type.typeIsNumber()) {
            return type;
        }
        return null;
    }

    public static Type getType(Object o) {
        if (o == null) {
            return null;
        }
        Type type = TypeManager.GET_TYPE.getType(o);
        if (type == null) {
            throw new RuntimeException(o.toString() + ",\u7c7b\u578b" + o.getClass().getName() + " \u4e0d\u652f\u6301");
        }
        return type;
    }

    public static Type getTypeByClass(Class<?> clazz) {
        Type type = TypeManager.classTypeMap.get(clazz);
        if (type == null) {
            throw new TypeNotFindException(clazz);
        }
        return type;
    }

    public static Type getTypeByName(String typeName) {
        Optional<Type> optional = TypeManager.typeSet.stream().filter(type -> type.getEnum().name().equalsIgnoreCase(typeName)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> wraperClass) {
        return TypeManager.getPrimitiveType(wraperClass);
    }

    public static Class<?> getWraper(Class<?> wraperClass) {
        return TypeManager.getWraper(wraperClass);
    }

    public static boolean isWraper(Class<?> wraperClass) {
        return TypeManager.isWraper(wraperClass);
    }

    public static Object convert(Object value, Class<?> clazz) {
        Type type = Types.getTypeByClass(clazz);
        return type.toType(value);
    }

    public static String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        Type type = Types.getType(o);
        return type.valueToString(o);
    }

    public static enum TYPE_ENUM {
        Integer,
        Timestamp,
        Short,
        Long,
        Float,
        Double,
        Bytes,
        String,
        Boolean,
        Void,
        Geometry,
        BigDecimal,
        Unknown,
        Any,
        VOID,
        Enum;

    }
}

