/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Joys {
    public static <R> R tryTimes(Supplier<R> s, int times, int retryDelay) throws Exception {
        Exception exception = null;
        for (int trytimes = 0; trytimes < times; ++trytimes) {
            try {
                R r = s.get();
                return r;
            }
            catch (Exception e) {
                e.printStackTrace();
                exception = e;
                Thread.sleep(retryDelay);
                continue;
            }
        }
        throw new Exception("\u8d85\u8fc7\u6700\u5927\u5c1d\u8bd5\u6b21\u6570,\u5c1d\u8bd5\u5931\u8d25" + exception.getMessage());
    }

    private static <R> void asyncTry(Supplier<R> s, int time, int maxTimes, int retryDelay, ScheduledExecutorService service, CompletableFuture<R> future) {
        service.schedule(() -> {
            try {
                Object r = s.get();
                future.complete(r);
            }
            catch (Exception e) {
                if (time == maxTimes) {
                    future.completeExceptionally(e);
                }
                int timeNext = time + 1;
                Joys.asyncTry(s, timeNext, maxTimes, retryDelay, service, future);
            }
        }, (long)retryDelay, TimeUnit.MILLISECONDS);
    }

    public static <R> CompletableFuture<R> asyncTryTimes(Supplier<R> s, int times, int retryDelay, ScheduledExecutorService service) {
        CompletableFuture<R> future = new CompletableFuture<R>();
        try {
            R r = s.get();
            future.complete(r);
        }
        catch (Exception e) {
            int timeNext = 1;
            Joys.asyncTry(s, timeNext, times, retryDelay, service, future);
        }
        return future;
    }

    public static Integer get() throws Exception {
        System.out.println("do");
        Thread.sleep(1000L);
        throw new Exception("aaaaaaaaaa");
    }

    public static void main(String[] aaa) {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        CompletableFuture<Integer> f = Joys.asyncTryTimes(() -> {
            Integer i = 0;
            try {
                i = Joys.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return i;
        }, 10, 1000, service);
        try {
            f.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        System.out.println("ccccccc");
    }
}

