/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    private ZipUtils() {
    }

    public static void doCompress(String srcFile, String zipFile, String wipeHead) throws Exception {
        ZipUtils.doCompress(new File(srcFile), new File(zipFile), wipeHead);
    }

    public static void doCompress(File srcFile, File zipFile, String wipeHead) throws Exception {
        ZipOutputStream out = null;
        FileOutputStream fout = new FileOutputStream(zipFile);
        try {
            out = new ZipOutputStream(fout);
            ZipUtils.doCompress(srcFile, out, wipeHead);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            out.close();
            fout.close();
        }
    }

    public static void doCompress(String filelName, ZipOutputStream out, String wipeHead) throws IOException {
        ZipUtils.doCompress(new File(filelName), out, wipeHead);
    }

    public static void doCompress(File file, ZipOutputStream out, String wipeHead) throws IOException {
        ZipUtils.doCompress(file, out, "", true, wipeHead);
    }

    public static void doCompress(File inFile, ZipOutputStream out, String dir, Boolean saveDir, String wipeHead) throws IOException {
        if (inFile.isDirectory()) {
            File[] files = inFile.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    String name = inFile.getName();
                    if (saveDir.booleanValue()) {
                        if (!wipeHead.equals(name)) {
                            if (!"".equals(dir)) {
                                name = dir + "/" + name;
                            }
                        } else {
                            name = "";
                        }
                    } else {
                        name = inFile.isDirectory() ? "" : file.getName();
                    }
                    ZipUtils.doCompress(file, out, name, true, wipeHead);
                }
            }
        } else {
            ZipUtils.doZip(inFile, out, dir);
        }
    }

    public static void doZip(File inFile, ZipOutputStream out, String dir) throws IOException {
        String entryName = null;
        entryName = !"".equals(dir) ? dir + "/" + inFile.getName() : inFile.getName();
        ZipEntry entry = new ZipEntry(entryName);
        out.putNextEntry(entry);
        int len = 0;
        byte[] buffer = new byte[1024];
        FileInputStream fis = new FileInputStream(inFile);
        while ((len = fis.read(buffer)) > 0) {
            out.write(buffer, 0, len);
            out.flush();
        }
        out.closeEntry();
        fis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destination) throws IOException {
        if (destination.exists() && destination.isDirectory()) {
            try (ZipInputStream zipInputStream = null;){
                zipInputStream = new ZipInputStream(new FileInputStream(zipFile));
                byte[] buf = new byte[1024];
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    String entryName = zipEntry.getName();
                    File newFile = new File(destination, entryName);
                    if (zipEntry.isDirectory()) {
                        newFile.mkdirs();
                    } else {
                        newFile.getParentFile().mkdirs();
                        try (FileOutputStream fileoutputstream = null;){
                            int n;
                            fileoutputstream = new FileOutputStream(newFile);
                            while ((n = zipInputStream.read(buf, 0, 1024)) > -1) {
                                fileoutputstream.write(buf, 0, n);
                            }
                        }
                    }
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
        }
        throw new IllegalArgumentException("Invalid destination: " + destination.getCanonicalPath());
    }
}

