/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.classloader;

import com.geoway.vtile.commons.util.ByteBufferInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import sun.net.www.MessageHeader;
import sun.net.www.ParseUtil;

public class MemoryURLConnection
extends sun.net.www.URLConnection {
    static String CONTENT_LENGTH = "content-length";
    static String CONTENT_TYPE = "content-type";
    static String TEXT_PLAIN = "text/plain";
    static String LAST_MODIFIED = "last-modified";
    String contentType;
    InputStream is;
    ByteBuffer content;
    String filename;
    boolean isDirectory = false;
    boolean exists = false;
    List<String> files;
    long length = -1L;
    long lastModified = 0L;
    private boolean initializedHeaders = false;
    Permission permission;

    public MemoryURLConnection(URL url, String filename, ByteBuffer content) {
        super(url);
        this.content = content;
        this.filename = filename;
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            this.is = new ByteBufferInputStream(this.content);
            this.connected = true;
        }
    }

    private void initializeHeaders() {
        try {
            this.connect();
            this.exists = this.content != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.initializedHeaders || !this.exists) {
            this.length = this.content.capacity();
            if (!this.isDirectory) {
                FileNameMap var1 = URLConnection.getFileNameMap();
                this.contentType = var1.getContentTypeFor(this.filename);
                if (this.contentType != null) {
                    this.properties.add(CONTENT_TYPE, this.contentType);
                }
                this.properties.add(CONTENT_LENGTH, String.valueOf(this.length));
                if (this.lastModified != 0L) {
                    Date var2 = new Date(this.lastModified);
                    SimpleDateFormat var3 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
                    var3.setTimeZone(TimeZone.getTimeZone("GMT"));
                    this.properties.add(LAST_MODIFIED, var3.format(var2));
                }
            } else {
                this.properties.add(CONTENT_TYPE, TEXT_PLAIN);
            }
            this.initializedHeaders = true;
        }
    }

    @Override
    public String getHeaderField(String var1) {
        this.initializeHeaders();
        return super.getHeaderField(var1);
    }

    @Override
    public String getHeaderField(int var1) {
        this.initializeHeaders();
        return super.getHeaderField(var1);
    }

    @Override
    public int getContentLength() {
        this.initializeHeaders();
        return this.length > Integer.MAX_VALUE ? -1 : (int)this.length;
    }

    @Override
    public long getContentLengthLong() {
        this.initializeHeaders();
        return this.length;
    }

    @Override
    public String getHeaderFieldKey(int var1) {
        this.initializeHeaders();
        return super.getHeaderFieldKey(var1);
    }

    @Override
    public MessageHeader getProperties() {
        this.initializeHeaders();
        return super.getProperties();
    }

    @Override
    public long getLastModified() {
        this.initializeHeaders();
        return this.lastModified;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.connect();
        return this.is;
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.permission == null) {
            String var1 = ParseUtil.decode(this.url.getPath());
            this.permission = File.separatorChar == '/' ? new FilePermission(var1, "read") : new FilePermission(var1.replace('/', File.separatorChar), "read");
        }
        return this.permission;
    }
}

