/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.geofeature;

import com.geoway.vtile.commons.util.BuilderCreator;
import com.geoway.vtile.commons.util.DoubleBuilder;
import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoBufferJTSConverter;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import com.geoway.vtile.spatial.wkt.WktEncoder;
import java.util.ArrayList;
import org.locationtech.jts.algorithm.RobustDeterminant;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.ProjCoordinate;

public class GeoBuffer {
    Constants.GEO_TYPE geoType;
    private ArrayList<GeoPart> partList = new ArrayList();
    int srid = 0;
    int dimension = 2;
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double z = Double.NaN;
    private double minX = Double.NaN;
    private double minY = Double.NaN;
    private double maxX = Double.NaN;
    private double maxY = Double.NaN;

    public void addPoint(double x, double y) {
        if (this.dimension == 2) {
            this.addPoint(x, y, Double.NaN);
        } else {
            this.addPoint(x, y, 0.0);
        }
    }

    public void addPoint(double x, double y, double z) {
        if (this.geoType != Constants.GEO_TYPE.POINT && this.geoType != Constants.GEO_TYPE.MULTIPOINT) {
            return;
        }
        if (this.partList == null || this.partList.isEmpty()) {
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble(this.dimension);
            doubleBuilder.append(x);
            doubleBuilder.append(y);
            if (this.dimension == 3) {
                doubleBuilder.append(z);
            }
            GeoPart geoPart = new GeoPart(doubleBuilder, this);
            this.partList.add(geoPart);
        } else {
            GeoPart geoPart = this.partList.get(0);
            DoubleBuilder doubleBuilder = geoPart.getDoubleBuilder();
            doubleBuilder.append(x);
            doubleBuilder.append(y);
            if (this.dimension == 3) {
                doubleBuilder.append(z);
            }
            this.addPointPart(doubleBuilder);
        }
    }

    public GeoBuffer dimensionTo2() {
        if (this.dimension == 2) {
            return this;
        }
        GeoBuffer newBuffer = new GeoBuffer(this.geoType, this.srid, 2);
        newBuffer.maxX = this.maxX;
        newBuffer.minX = this.minX;
        newBuffer.maxY = this.maxY;
        newBuffer.minY = this.minY;
        newBuffer.x = this.x;
        newBuffer.y = this.y;
        newBuffer.z = Double.NaN;
        ArrayList<GeoPart> partList = new ArrayList<GeoPart>(this.partList.size());
        for (GeoPart part : this.partList) {
            int size = part.doubleBuilder.size() / 3;
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble(size * 2);
            for (int i = 0; i < size; ++i) {
                doubleBuilder.append(part.doubleBuilder.get(i * 3));
                doubleBuilder.append(part.doubleBuilder.get(i * 3 + 1));
            }
            GeoPart newPart = new GeoPart(doubleBuilder, part.minX, part.minY, part.maxX, part.maxY, newBuffer, part.ringType);
            partList.add(newPart);
        }
        newBuffer.partList = partList;
        return newBuffer;
    }

    public GeoBuffer dimensionTo3() {
        if (this.dimension == 3) {
            return this;
        }
        GeoBuffer newBuffer = new GeoBuffer(this.geoType, this.srid, 3);
        newBuffer.maxX = this.maxX;
        newBuffer.minX = this.minX;
        newBuffer.maxY = this.maxY;
        newBuffer.minY = this.minY;
        newBuffer.x = this.x;
        newBuffer.y = this.y;
        newBuffer.z = 0.0;
        ArrayList<GeoPart> partList = new ArrayList<GeoPart>(this.partList.size());
        for (GeoPart part : partList) {
            int size = part.doubleBuilder.size() / 2;
            DoubleBuilder doubleBuilder = BuilderCreator.createDouble(size * 3);
            for (int i = 0; i < size; ++i) {
                doubleBuilder.append(part.doubleBuilder.get(i * 3));
                doubleBuilder.append(part.doubleBuilder.get(i * 3 + 1));
                doubleBuilder.append(0.0);
            }
            GeoPart newPart = new GeoPart(doubleBuilder, part.minX, part.minY, part.maxX, part.maxY, newBuffer, part.ringType);
            partList.add(newPart);
        }
        return newBuffer;
    }

    public void setBBOX(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public double[] zInterval() {
        double minZ = Double.NaN;
        double maxZ = Double.NaN;
        if (this.geoType == Constants.GEO_TYPE.POINT) {
            minZ = maxZ = this.getZ();
        } else {
            int i = 0;
            if (this.partList.size() == 1) {
                return this.partList.get(0).zInterval();
            }
            for (GeoPart part : this.partList) {
                double[] subZInterval = part.zInterval();
                if (i == 0) {
                    minZ = subZInterval[0];
                    maxZ = subZInterval[1];
                } else {
                    if (subZInterval[0] < minZ) {
                        minZ = subZInterval[0];
                    }
                    if (subZInterval[1] > maxZ) {
                        maxZ = subZInterval[1];
                    }
                }
                ++i;
            }
        }
        return new double[]{minZ, maxZ};
    }

    public double getX() {
        if (this.geoType != Constants.GEO_TYPE.POINT || this.partList == null || this.partList.isEmpty()) {
            return Double.NaN;
        }
        return this.partList.get(0).getDoubleBuilder().get(0);
    }

    public double getY() {
        if (this.geoType != Constants.GEO_TYPE.POINT || this.partList == null || this.partList.isEmpty()) {
            return Double.NaN;
        }
        return this.partList.get(0).getDoubleBuilder().get(1);
    }

    public double getZ() {
        if (this.geoType != Constants.GEO_TYPE.POINT || this.dimension == 2 || this.partList == null || this.partList.isEmpty()) {
            return Double.NaN;
        }
        return this.partList.get(0).getDoubleBuilder().get(2);
    }

    public int getCoordinateCount() {
        int count = 0;
        if (this.geoType == Constants.GEO_TYPE.POINT) {
            return 1;
        }
        for (int i = 0; i < this.getPartList().size(); ++i) {
            GeoPart part = this.getPartList().get(i);
            count += part.getCoordinateCount();
        }
        return count;
    }

    public double[] getBBOX() {
        if (Double.isNaN(this.minX)) {
            if (this.geoType == Constants.GEO_TYPE.POINT) {
                this.minX = this.maxX = this.getX();
                this.minY = this.maxY = this.getY();
            } else {
                int i = 0;
                if (this.partList.size() == 1) {
                    return this.partList.get(0).getBBOX();
                }
                for (GeoPart part : this.partList) {
                    if (part.getRingType() == GeoPart.RING_TYPE.inside) continue;
                    double[] subBBOX = part.getBBOX();
                    if (i == 0) {
                        this.minX = subBBOX[0];
                        this.minY = subBBOX[1];
                        this.maxX = subBBOX[2];
                        this.maxY = subBBOX[3];
                    } else {
                        if (subBBOX[0] < this.minX) {
                            this.minX = subBBOX[0];
                        }
                        if (subBBOX[1] < this.minY) {
                            this.minY = subBBOX[1];
                        }
                        if (subBBOX[2] > this.maxX) {
                            this.maxX = subBBOX[2];
                        }
                        if (subBBOX[3] > this.maxY) {
                            this.maxY = subBBOX[3];
                        }
                    }
                    ++i;
                }
            }
        }
        return new double[]{this.minX, this.minY, this.maxX, this.maxY};
    }

    public Integer getPartSize() {
        return this.partList.size();
    }

    public double[] getPoint() {
        if (this.partList == null || this.partList.isEmpty()) {
            return null;
        }
        GeoPart part = this.partList.get(0);
        DoubleBuilder doubleBuilder = part.getDoubleBuilder();
        if (this.dimension == 3) {
            return new double[]{doubleBuilder.get(0), doubleBuilder.get(1), doubleBuilder.get(2)};
        }
        return new double[]{doubleBuilder.get(0), doubleBuilder.get(1)};
    }

    public double[] getPoint(Integer index) {
        if (this.partList == null || this.partList.isEmpty()) {
            return null;
        }
        GeoPart part = this.partList.get(0);
        DoubleBuilder doubleBuilder = part.getDoubleBuilder();
        if (this.dimension == 3) {
            return new double[]{doubleBuilder.get(index * 3), doubleBuilder.get(index * 3 + 1), doubleBuilder.get(index * 3 + 2)};
        }
        return new double[]{doubleBuilder.get(index * 2), doubleBuilder.get(index * 2 + 1)};
    }

    public String toWkt() {
        return WktEncoder.ENCODER.fromGeoBuffer(this);
    }

    public String toString() {
        return this.toWkt();
    }

    public DoubleBuilder getData(Integer index) {
        GeoPart part = this.partList.get(index);
        if (part == null) {
            return null;
        }
        return part.getDoubleBuilder();
    }

    public GeoPart getPart(Integer index) {
        return this.partList.get(index);
    }

    public void tryMultiToSingle() {
        int partSize = this.partList.size();
        if (this.geoType == Constants.GEO_TYPE.MULTILINESTRING && partSize == 1) {
            this.geoType = Constants.GEO_TYPE.LINESTRING;
        }
        if (this.geoType == Constants.GEO_TYPE.MULTIPOLYGON) {
            int out_side_occur_times = 0;
            for (GeoPart part : this.partList) {
                if (part.getRingType() != GeoPart.RING_TYPE.outside) continue;
                if (out_side_occur_times == 0) {
                    out_side_occur_times = 1;
                    continue;
                }
                ++out_side_occur_times;
                break;
            }
            if (out_side_occur_times == 1) {
                this.geoType = Constants.GEO_TYPE.POLYGON;
            }
        }
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public Integer getSRID() {
        return this.srid;
    }

    public void setSRID(Integer srid) {
        this.srid = srid;
    }

    public GeoBuffer(Constants.GEO_TYPE geoType) {
        this.geoType = geoType;
        this.srid = 0;
    }

    public GeoBuffer(Constants.GEO_TYPE geoType, int srid) {
        this.geoType = geoType;
        this.srid = srid;
    }

    public GeoBuffer(Constants.GEO_TYPE geoType, int srid, int dimension) {
        this.geoType = geoType;
        this.srid = srid;
        if (dimension != 2 && dimension != 3) {
            throw new RuntimeException(String.format("\u76ee\u524d\u4e0d\u652f\u6301\u7ef4\u5ea6\u4e3a%s\u7684Coordinate\u5bf9\u8c61", dimension));
        }
        this.dimension = dimension;
    }

    public void trimToSize() {
        for (GeoPart part : this.partList) {
            part.doubleBuilder.trimToSize();
        }
    }

    public Constants.GEO_TYPE getGeoType() {
        return this.geoType;
    }

    public ArrayList<GeoPart> getPartList() {
        return this.partList;
    }

    public void setPartList(ArrayList<GeoPart> partList) {
        this.partList = partList;
    }

    public void add(GeoPart part) {
        this.partList.add(part);
    }

    public void destroy() {
        this.partList.forEach(part -> part.doubleBuilder.destroy());
    }

    public static GeoBuffer fromJTSGeometry(Geometry geometry) {
        return GeoBufferJTSConverter.GEO_BUFFER_JTS_CONVERTER.fromGeometry(geometry);
    }

    public Geometry toJTSGeometry() {
        return GeoBufferJTSConverter.GEO_BUFFER_JTS_CONVERTER.toGeometry(this);
    }

    public void addPointPart(DoubleBuilder doubleBuilder) {
        GeoPart geoPart = new GeoPart(doubleBuilder, this);
        this.partList.add(geoPart);
    }

    public void addLinePart(DoubleBuilder doubleBuilder, double minX, double minY, double maxX, double maxY) {
        GeoPart geoPart = new GeoPart(doubleBuilder, minX, minY, maxX, maxY, this);
        this.partList.add(geoPart);
    }

    public void addPolygonPart(DoubleBuilder doubleBuilder, double minX, double minY, double maxX, double maxY, GeoPart.RING_TYPE ringType) {
        GeoPart geoPart = new GeoPart(doubleBuilder, minX, minY, maxX, maxY, this, ringType);
        this.partList.add(geoPart);
    }

    static boolean equals2D(DoubleBuilder doubleBuilder, int i, int j, int dimension) {
        return doubleBuilder.get(i * dimension) == doubleBuilder.get(j * dimension) && doubleBuilder.get(i * dimension + 1) == doubleBuilder.get(j * dimension + 1);
    }

    public static boolean isCCW(DoubleBuilder doubleBuilder, int dimension) {
        int nPts = doubleBuilder.size() / dimension - 1;
        double hiy = doubleBuilder.get(1);
        int hiIndex = 0;
        for (int i = 1; i <= nPts; ++i) {
            double y = doubleBuilder.get(i * dimension + 1);
            if (!(y > hiy)) continue;
            hiy = y;
            hiIndex = i;
        }
        int iPrev = hiIndex;
        do {
            if (--iPrev >= 0) continue;
            iPrev = nPts;
        } while (GeoBuffer.equals2D(doubleBuilder, iPrev, hiIndex, dimension) && iPrev != hiIndex);
        int iNext = hiIndex;
        while (GeoBuffer.equals2D(doubleBuilder, iNext = (iNext + 1) % nPts, hiIndex, dimension) && iNext != hiIndex) {
        }
        if (GeoBuffer.equals2D(doubleBuilder, iPrev, hiIndex, dimension) || GeoBuffer.equals2D(doubleBuilder, iNext, hiIndex, dimension) || GeoBuffer.equals2D(doubleBuilder, iPrev, iNext, dimension)) {
            return false;
        }
        int disc = GeoBuffer.computeOrientation(doubleBuilder, dimension, iPrev, hiIndex, iNext);
        boolean isCCW = false;
        isCCW = disc == 0 ? doubleBuilder.get(iPrev * dimension) > doubleBuilder.get(iPrev * dimension) : disc > 0;
        return isCCW;
    }

    static int computeOrientation(DoubleBuilder doubleBuilder, int dimension, int p1, int p2, int q) {
        double p1x = doubleBuilder.get(p1 * dimension);
        double p1y = doubleBuilder.get(p1 * dimension + 1);
        double p2x = doubleBuilder.get(p2 * dimension);
        double p2y = doubleBuilder.get(p2 * dimension + 1);
        double qx = doubleBuilder.get(q * dimension);
        double qy = doubleBuilder.get(q * dimension + 1);
        double dx1 = p2x - p1x;
        double dy1 = p2y - p1y;
        double dx2 = qx - p2x;
        double dy2 = qy - p2y;
        return RobustDeterminant.signOfDet2x2((double)dx1, (double)dy1, (double)dx2, (double)dy2);
    }

    public static DoubleBuilder reverseCoordinates(DoubleBuilder doubleBuilder, int dimension) {
        int last;
        int coordinatesSize = doubleBuilder.size() / dimension;
        DoubleBuilder doubleBuilderReverse = BuilderCreator.createDouble(doubleBuilder.size());
        for (int i = last = coordinatesSize - 1; i >= 0; --i) {
            for (int j = 0; j < dimension; ++j) {
                double value = doubleBuilder.get(i * dimension + j);
                doubleBuilderReverse.append(value);
            }
        }
        return doubleBuilderReverse;
    }

    public boolean isMultiPart() {
        int partSize = this.partList.size();
        if (this.geoType == Constants.GEO_TYPE.MULTIPOINT || this.geoType == Constants.GEO_TYPE.MULTILINESTRING) {
            return partSize > 1;
        }
        if (this.geoType == Constants.GEO_TYPE.MULTIPOLYGON) {
            int outSideOccurTimes = 0;
            for (GeoPart part : this.partList) {
                if (part.getRingType() != GeoPart.RING_TYPE.outside) continue;
                if (outSideOccurTimes == 0) {
                    outSideOccurTimes = 1;
                    continue;
                }
                ++outSideOccurTimes;
                break;
            }
            return outSideOccurTimes > 1;
        }
        return false;
    }

    public void project(CoordinateTransform coordTransfrom) {
        double[] outxy = new double[2];
        for (GeoPart part : this.partList) {
            DoubleBuilder xys = part.getDoubleBuilder();
            int size = xys.size();
            DoubleBuilder projDoubles = BuilderCreator.createDouble(size);
            for (int i = 0; i < size / 2; ++i) {
                this.projectCoord(coordTransfrom, xys.get(i * 2), xys.get(i * 2 + 1), outxy);
                projDoubles.append(outxy[0]);
                projDoubles.append(outxy[1]);
            }
            part.setDoubleBuilder(projDoubles);
            this.projectCoord(coordTransfrom, part.minX, part.minY, outxy);
            part.setMinX(outxy[0]);
            part.setMinY(outxy[1]);
            this.projectCoord(coordTransfrom, part.maxX, part.maxY, outxy);
            part.setMaxX(outxy[0]);
            part.setMaxY(outxy[1]);
        }
    }

    public void projectCoord(CoordinateTransform coordTransfrom, double x, double y, double[] outxy) {
        ProjCoordinate target = new ProjCoordinate();
        coordTransfrom.transform(new ProjCoordinate(x, y), target);
        outxy[0] = target.x;
        outxy[1] = target.y;
    }
}

