/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.spatial.wkb;

import com.geoway.vtile.spatial.Constants;
import com.geoway.vtile.spatial.geofeature.GeoBuffer;
import com.geoway.vtile.spatial.geofeature.GeoPart;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public abstract class AbstractWkbEncoder {
    protected AbstractWkbEncoder() {
    }

    public byte[] _fromGeoBuffer(GeoBuffer geoBuffer, ByteOrder byteOrder, boolean includeSrid) {
        ByteBuffer byteBuffer = this.byteBufferFromGeoBuffer(geoBuffer, byteOrder, includeSrid);
        int len = byteBuffer.limit() - byteBuffer.position();
        byte[] bytes = new byte[len];
        byteBuffer.get(bytes);
        return bytes;
    }

    public ByteBuffer byteBufferFromGeoBuffer(GeoBuffer geoBuffer, ByteOrder byteOrder, boolean includeSrid) {
        ByteBuffer buffer;
        Constants.GEO_TYPE geotype = geoBuffer.getGeoType();
        int dimension = geoBuffer.getDimension();
        int size = 0;
        GeoPart[] parts = geoBuffer.getPartList().toArray(new GeoPart[geoBuffer.getPartList().size()]);
        int srid = geoBuffer.getSRID();
        switch (geotype) {
            case POINT: {
                size = this.calculatePoint(size, geoBuffer.getDimension(), includeSrid);
                buffer = this.allocate(size, byteOrder);
                this.processPoint(dimension, geoBuffer.getX(), geoBuffer.getY(), geoBuffer.getZ(), byteOrder, buffer, srid, includeSrid);
                break;
            }
            case LINESTRING: {
                size = this.calculateLineString(size, geoBuffer.getDimension(), geoBuffer.getPartList().get(0), includeSrid);
                buffer = this.allocate(size, byteOrder);
                this.processLineString(dimension, byteOrder, buffer, 0, geoBuffer.getPartList().get(0), srid, includeSrid);
                break;
            }
            case POLYGON: {
                size = this.calculatePolygon(size, geoBuffer.getDimension(), parts, includeSrid);
                buffer = this.allocate(size, byteOrder);
                this.processPolygon(dimension, byteOrder, buffer, 0, parts, srid, includeSrid);
                break;
            }
            case MULTILINESTRING: {
                size = this.calculateMultiLineString(size, geoBuffer.getDimension(), parts, includeSrid);
                buffer = this.allocate(size, byteOrder);
                this.processMultiLineString(dimension, byteOrder, buffer, 0, parts, srid, includeSrid);
                break;
            }
            case MULTIPOLYGON: {
                GeoPart[][] polygons = this.multiPolygonChange(parts);
                size = this.calculateMultiPolygon(size, dimension, polygons, includeSrid);
                buffer = this.allocate(size, byteOrder);
                this.processMultiPolygon(dimension, byteOrder, buffer, 0, polygons, srid, includeSrid);
                break;
            }
            default: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u51e0\u4f55\u7c7b\u578b\uff1a" + geotype.name());
            }
        }
        return buffer;
    }

    private int processMultiPolygon(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset, GeoPart[][] polygons, int srid, boolean includeSrid) {
        offset = this.writeByteOrder(offset, buffer, byteOrder);
        offset = this.writeGeometryType(offset, 6, dimension, buffer, includeSrid, srid);
        int geoPartCount = polygons.length;
        offset = this.writeGeoPartCount(offset, geoPartCount, buffer);
        for (int i = 0; i < polygons.length; ++i) {
            GeoPart[] polygon = polygons[i];
            offset = this.processPolygon(dimension, byteOrder, buffer, offset, polygon, srid, false);
        }
        return offset;
    }

    private int processMultiLineString(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset, GeoPart[] parts, int srid, boolean includeSrid) {
        offset = this.writeByteOrder(offset, buffer, byteOrder);
        offset = this.writeGeometryType(offset, 5, dimension, buffer, includeSrid, srid);
        int geoPartCount = parts.length;
        offset = this.writeGeoPartCount(offset, geoPartCount, buffer);
        for (int i = 0; i < parts.length; ++i) {
            offset = this.processLineString(dimension, byteOrder, buffer, offset, parts[i], i, false);
        }
        return offset;
    }

    private int processPolygon(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset, GeoPart[] parts, int srid, boolean includeSrid) {
        offset = this.writeByteOrder(offset, buffer, byteOrder);
        offset = this.writeGeometryType(offset, 3, dimension, buffer, includeSrid, srid);
        int geoPartCount = parts.length;
        offset = this.writeGeoPartCount(offset, geoPartCount, buffer);
        for (int i = 0; i < parts.length; ++i) {
            offset = this.writeCoordinateSequence(offset, parts[i], buffer, dimension);
        }
        return offset;
    }

    private int writeGeoPartCount(int offset, int geoPartCount, ByteBuffer buffer) {
        buffer.putInt(offset, geoPartCount);
        return offset += 4;
    }

    private int calculateMultiPolygon(int size, int dimension, GeoPart[][] multiPolygonGeoPart, boolean includeSrid) {
        size = 5 + (includeSrid ? 4 : 0) + 4;
        for (int i = 0; i < multiPolygonGeoPart.length; ++i) {
            GeoPart[] part = multiPolygonGeoPart[i];
            size = this.calculatePolygon(size, dimension, part, false);
        }
        return size;
    }

    private GeoPart[][] multiPolygonChange(GeoPart[] parts) {
        ArrayList<GeoPart[]> partPolygon = new ArrayList<GeoPart[]>();
        int polygonSzie = 0;
        ArrayList<GeoPart> polygon = new ArrayList<GeoPart>();
        for (int i = 0; i < parts.length; ++i) {
            GeoPart part = parts[i];
            if (part.getRingType() == GeoPart.RING_TYPE.outside) {
                if (polygonSzie != 0) {
                    partPolygon.add(polygon.toArray(new GeoPart[polygon.size()]));
                    polygon = new ArrayList();
                }
                ++polygonSzie;
            }
            polygon.add(part);
        }
        partPolygon.add(polygon.toArray(new GeoPart[polygon.size()]));
        return (GeoPart[][])partPolygon.toArray((T[])new GeoPart[partPolygon.size()][]);
    }

    private int calculateMultiLineString(int size, int dimension, GeoPart[] parts, boolean includeSrid) {
        size = size + 1 + 4 + (includeSrid ? 4 : 0) + 4;
        for (int i = 0; i < parts.length; ++i) {
            GeoPart part = parts[i];
            size = this.calculateLineString(size, dimension, part, false);
        }
        return size;
    }

    private int calculatePolygon(int size, int dimension, GeoPart[] parts, boolean includeSrid) {
        size = size + 1 + 4 + (includeSrid ? 4 : 0) + 4;
        for (int i = 0; i < parts.length; ++i) {
            GeoPart part = parts[i];
            size = this.calculateCoordinateSequence(size, dimension, part);
        }
        return size;
    }

    private int calculateCoordinateSequence(int size, int dimension, GeoPart part) {
        size += 4;
        return size += part.getCoordinateCount() * (dimension * 8);
    }

    private int calculateLineString(int size, int dimension, GeoPart part, boolean includeSrid) {
        size = 5 + (includeSrid ? 4 : 0) + this.calculateCoordinateSequence(size, dimension, part);
        return size;
    }

    private int calculatePoint(int size, int dimension, boolean includeSrid) {
        size = size + 1 + 4 + (includeSrid ? 4 : 0) + dimension * 8;
        return size;
    }

    private ByteBuffer allocate(int size, ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(byteOrder);
        return buffer;
    }

    void put(int offset, ByteBuffer buffer, byte b) {
        buffer.put(offset, b);
    }

    void putInt(int offset, ByteBuffer buffer, int i) {
        buffer.putInt(offset, i);
    }

    void putDouble(int offset, ByteBuffer buffer, double d) {
        buffer.putDouble(offset, d);
    }

    int writeByteOrder(int offset, ByteBuffer buffer, ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.put(offset, buffer, (byte)1);
        } else {
            this.put(offset, buffer, (byte)0);
        }
        return ++offset;
    }

    int writeGeometryType(int offset, int geometryType, int dimension, ByteBuffer buffer, boolean includeSrid, int srid) {
        int flag3D = dimension == 3 ? Integer.MIN_VALUE : 0;
        int flagSRID = includeSrid ? 0x20000000 : 0;
        int typeInt = geometryType | flag3D | flagSRID;
        this.putInt(offset, buffer, typeInt);
        offset += 4;
        if (includeSrid) {
            offset = this.writeSRID(offset, buffer, srid);
        }
        return offset;
    }

    void processPoint(int dimension, double x, double y, double z, ByteOrder byteOrder, ByteBuffer buffer, int srid, boolean includeSrid) {
        int offset = 0;
        offset = this.writeByteOrder(offset, buffer, byteOrder);
        offset = this.writeGeometryType(offset, 1, dimension, buffer, includeSrid, srid);
        this.putDouble(offset, buffer, x);
        this.putDouble(offset += 8, buffer, y);
        offset += 8;
        if (dimension == 3) {
            this.putDouble(offset, buffer, z);
            offset += 8;
        }
    }

    private int writeSRID(int offset, ByteBuffer buffer, int srid) {
        this.putInt(offset, buffer, srid);
        return offset += 4;
    }

    int processLineString(int dimension, ByteOrder byteOrder, ByteBuffer buffer, int offset, GeoPart part, int srid, boolean includeSrid) {
        offset = this.writeByteOrder(offset, buffer, byteOrder);
        offset = this.writeGeometryType(offset, 2, dimension, buffer, includeSrid, srid);
        offset = this.writeCoordinateSequence(offset, part, buffer, dimension);
        return offset;
    }

    private int writeCoordinateSequence(int offset, GeoPart part, ByteBuffer buffer, int dimension) {
        int coordinateCount = part.getCoordinateCount();
        offset = this.writeCoordinateCount(offset, coordinateCount, buffer);
        for (int i = 0; i < coordinateCount; ++i) {
            int index = i * dimension;
            this.putDouble(offset, buffer, part.getDoubleBuilder().get(index));
            this.putDouble(offset += 8, buffer, part.getDoubleBuilder().get(index + 1));
            offset += 8;
            if (dimension != 3) continue;
            this.putDouble(offset, buffer, part.getDoubleBuilder().get(index + 2));
            offset += 8;
        }
        return offset;
    }

    private int writeCoordinateCount(int offset, int coordinateCount, ByteBuffer buffer) {
        this.putInt(offset, buffer, coordinateCount);
        return offset += 4;
    }

    public static void main(String[] aaa) {
    }
}

