/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.commons.util;

import com.geoway.vtile.commons.util.FStringBuilder;
import com.geoway.vtile.commons.util.UnsafeFuntion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import sun.nio.ch.DirectBuffer;

public abstract class AbstractStringBuilder
implements FStringBuilder {
    private final int beginSize;
    private int expansionHeapTimes;
    private final int directApplySize;
    protected char[] heap;
    protected int capacity;
    protected int size;
    private Boolean isDirect;
    protected final int charSize = 2;
    protected final int directApplySizeNum;
    protected ArrayList<ByteBuffer> directBufferArr;
    protected ByteBuffer currentDirectByteBuffer;
    protected UnsafeFuntion unsafe;

    public abstract ByteOrder order();

    public AbstractStringBuilder() {
        this.beginSize = this.charSize * 128;
        this.expansionHeapTimes = 1;
        this.directApplySize = 256 * this.charSize / 2;
        this.isDirect = false;
        this.charSize = 2;
        this.directApplySizeNum = this.directApplySize / this.charSize;
        this.currentDirectByteBuffer = null;
        this.unsafe = UnsafeFuntion.get();
        this.capacity = this.beginSize / this.charSize;
        this.heap = new char[this.capacity];
    }

    public AbstractStringBuilder(String str) {
        this();
        this.append(str);
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            DirectBuffer db = (DirectBuffer)((Object)byteBuffer);
            db.cleaner().clean();
        }
    }

    @Override
    public Boolean isDirect() {
        return this.isDirect;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void expansionInHeap(int arrSize) {
        int applySize = this.beginSize * this.expansionHeapTimes / this.charSize;
        ++this.expansionHeapTimes;
        int newSize = applySize > arrSize ? this.capacity + applySize : arrSize + arrSize % applySize + this.capacity;
        char[] newHeap = new char[newSize];
        System.arraycopy(this.heap, 0, newHeap, 0, this.size);
        this.heap = newHeap;
        this.capacity = newSize;
    }

    private void expansionInDirect(int size) {
        if (size > this.directApplySizeNum) {
            int times = size / this.directApplySizeNum + 1;
            int newCapacity = this.directApplySizeNum * times;
            while (times-- > 0) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(newBuffer);
            }
            this.capacity = newCapacity;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity += this.directApplySizeNum;
        }
    }

    protected ByteBuffer getByteBuffer(int index) {
        return this.directBufferArr.get(index /= this.directApplySize);
    }

    private void toDirect(int size) {
        this.isDirect = true;
        int newSize = this.directApplySize;
        this.directBufferArr = new ArrayList();
        if ((size + this.capacity) * this.charSize > this.directApplySize) {
            int times = (size + this.capacity) * this.charSize / this.directApplySize + 1;
            int copyDone = 0;
            int newCapacity = this.directApplySize / this.charSize * times;
            while (times-- > 0) {
                ByteBuffer b = ByteBuffer.allocateDirect(this.directApplySize);
                this.directBufferArr.add(b);
                int directByteBufferSize = this.directApplySize / this.charSize;
                if (copyDone < this.size) {
                    if (this.size > directByteBufferSize) {
                        this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, directByteBufferSize);
                    } else {
                        if (this.heap.length - copyDone != 0) {
                            this.putArrIntoDirectByteBuffer(b, this.heap, copyDone, this.size - copyDone);
                        }
                        this.currentDirectByteBuffer = b;
                    }
                }
                copyDone += directByteBufferSize;
            }
            this.capacity = newCapacity;
        } else {
            this.capacity = this.directApplySize / this.charSize;
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.directApplySize);
            this.directBufferArr.add(newBuffer);
            this.currentDirectByteBuffer = newBuffer;
            this.capacity = newSize / this.charSize;
            this.putArrIntoDirectByteBuffer(newBuffer, this.heap, 0, this.size);
        }
    }

    public abstract void putArrIntoDirectByteBuffer(ByteBuffer var1, Object var2, int var3, int var4);

    @Override
    public void trimToSize() {
        if (!this.isDirect.booleanValue()) {
            char[] newHeap = new char[this.size];
            System.arraycopy(this.heap, 0, newHeap, 0, this.size);
            this.heap = newHeap;
        } else {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.currentDirectByteBuffer.position());
            this.currentDirectByteBuffer.flip();
            newBuffer.put(this.currentDirectByteBuffer);
            DirectBuffer db = (DirectBuffer)((Object)this.currentDirectByteBuffer);
            db.cleaner().clean();
            this.currentDirectByteBuffer = newBuffer;
        }
    }

    @Override
    public char get(int index) {
        if (this.isDirect.booleanValue()) {
            int dataBlockIndex = (index *= this.charSize) / this.directApplySize;
            int dbbIndex = index % this.directApplySize;
            return this.directBufferArr.get(dataBlockIndex).getChar(dbbIndex);
        }
        return this.heap[index];
    }

    @Override
    public void destroy() {
        if (this.isDirect.booleanValue()) {
            for (ByteBuffer bf : this.directBufferArr) {
                this.clean(bf);
            }
        }
    }

    private void ensureCapacityInternal(int size) {
        if (!this.isDirect.booleanValue()) {
            if ((this.capacity + size) * this.charSize + this.beginSize * this.expansionHeapTimes > this.directApplySize) {
                this.toDirect(size);
            } else {
                this.expansionInHeap(size);
            }
        } else {
            this.expansionInDirect(size);
        }
    }

    @Override
    public FStringBuilder append(String str) {
        if (str == null) {
            return this;
        }
        int offset = 0;
        int length = str.length();
        if (this.capacity < length - offset + this.size) {
            this.ensureCapacityInternal(length - offset);
        }
        if (this.isDirect.booleanValue()) {
            int beginBlockIndex = this.size / this.directApplySizeNum;
            int beginSubIndex = this.size % this.directApplySizeNum;
            int endBlockIndex = (length - offset + this.size) / this.directApplySizeNum + 1;
            int copyDone = 0;
            for (int i = beginBlockIndex; i < endBlockIndex; ++i) {
                int copyLength = this.directApplySizeNum;
                ByteBuffer dbb = this.directBufferArr.get(i);
                if (i == beginBlockIndex) {
                    copyLength = this.directApplySizeNum - beginSubIndex;
                }
                if (i == endBlockIndex - 1) {
                    copyLength = length - offset - copyDone;
                }
                this.putArrIntoDirectByteBuffer(dbb, this.unsafe.string2char(str), copyDone, copyLength);
                copyDone += copyLength;
            }
        } else {
            char[] arr = (char[])this.unsafe.string2char(str);
            System.arraycopy(arr, offset, this.heap, this.size, length - offset);
        }
        this.size = this.size + length - offset;
        return this;
    }

    public FStringBuilder delete(int start, int end) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    public FStringBuilder deleteAt(int index) {
        throw new RuntimeException("\u6ca1\u6709\u5b9e\u73b0");
    }

    static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[size=");
        sb.append(this.size);
        sb.append(" cap=");
        sb.append(this.capacity);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }
}

