/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.datasource.impl;

import com.geoway.vtile.dataschema.connection.OgrConnectionImpl;
import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.datasource.ogr.FGDBDataSource;
import com.geoway.vtile.datasource.ogr.IOgrShellDataSource;
import com.geoway.vtile.datasource.ogr.ShapeDataSource;
import java.io.IOException;
import java.sql.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrDataSource
extends DataSource {
    private Logger logger = LoggerFactory.getLogger(OgrDataSource.class);
    OgrConnectionImpl connection;
    org.gdal.ogr.DataSource ogrDataSource;

    public OgrDataSource(String filePath) throws IOException {
        OgrConnectionImpl ogrConnection;
        FGDBDataSource dataSource = null;
        if (filePath.endsWith(".gdb")) {
            dataSource = new FGDBDataSource(filePath);
        } else if (filePath.endsWith(".shp")) {
            dataSource = new ShapeDataSource(filePath);
        }
        this.connection = ogrConnection = new OgrConnectionImpl((IOgrShellDataSource)dataSource, filePath);
        this.ogrDataSource = ogrConnection.getReadShell().getDataSource();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

