/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.GetConnectionTimeoutException;
import com.alibaba.druid.util.StringUtils;
import com.geoway.vtile.dataschema.exception.BusinessException;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSource {
    private static Logger logger = LoggerFactory.getLogger(DataSource.class);
    public static final long MAX_WAIT = 10000L;
    protected String poorId;
    protected String url;
    protected String user;
    protected String password;
    protected DataSourceType type;
    protected DruidDataSource datasource;
    protected long createTime;
    protected long updateTime;
    protected boolean expired;

    public DataSource() {
    }

    public DataSource(String url, String user, String password, DataSourceType type) throws SQLException {
        if (StringUtils.isEmpty((CharSequence)url) || StringUtils.isEmpty((CharSequence)user) || type == null) {
            throw new BusinessException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u8fde\u63a5\u53c2\u6570");
        }
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(url);
        dataSource.setUsername(user);
        dataSource.setPassword(password);
        dataSource.setMaxWait(10000L);
        dataSource.setMaxActive(300);
        dataSource.setFailFast(true);
        dataSource.setBreakAfterAcquireFailure(true);
        dataSource.setNotFullTimeoutRetryCount(2);
        dataSource.setConnectionErrorRetryAttempts(2);
        dataSource.setDriverClassName(type.getDriver());
        try {
            dataSource.tryGetConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.poorId = url + "@" + user + "/" + password;
        this.user = user;
        this.url = url;
        this.password = password;
        this.type = type;
        this.datasource = dataSource;
        this.createTime = System.currentTimeMillis();
    }

    public Connection getConnection() throws SQLException {
        this.updateTime = System.currentTimeMillis();
        DruidPooledConnection conn = null;
        try {
            conn = this.datasource.getConnection();
        }
        catch (GetConnectionTimeoutException e) {
            if (conn != null) {
                conn.close();
            }
            this.datasource.close();
            this.datasource = null;
            throw new GetConnectionTimeoutException("\u8fde\u63a5\u8d85\u65f6");
        }
        return conn;
    }

    public DataSourceType getDbType() {
        return this.type;
    }

    public abstract boolean isValid();

    public void close() {
        if (this.datasource != null) {
            logger.info("\u5373\u5c06\u5173\u95ed\u8fde\u63a5\u6c60\uff1a" + this.poorId);
            this.datasource.close();
        }
    }

    public String getPoorId() {
        return this.poorId;
    }

    public void setPoorId(String poorId) {
        this.poorId = poorId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public void setType(DataSourceType type) {
        this.type = type;
    }

    public static enum DataSourceType {
        postgres("jdbc:postgresql://", "org.postgresql.Driver", 1),
        postgre("jdbc:postgresql://", "org.postgresql.Driver", 1),
        oracle("jdbc:oracle:thin:@", "oracle.jdbc.driver.OracleDriver", 3),
        mysql("jdbc:mysql://", "com.mysql.jdbc.Driver", 4),
        kingbase("jdbc:kingbase8://", "com.kingbase8.Driver", 5),
        highgo("jdbc:highgo://", "com.highgo.jdbc.Driver", 6),
        ogr("ogr://", "", 12),
        spark("", "", 31),
        hbase("", "", 32);

        private final String prefix;
        private final String driver;
        private final int code;

        private DataSourceType(String prefix, String driver, Integer code) {
            this.prefix = prefix;
            this.driver = driver;
            this.code = code;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getDriver() {
            return this.driver;
        }

        public int getCode() {
            return this.code;
        }
    }
}

