/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.datasource.manager;

import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.dataschema.datasource.impl.HbaseDataSource;
import com.geoway.vtile.dataschema.datasource.impl.HighgoDataSource;
import com.geoway.vtile.dataschema.datasource.impl.KingbaseDataSource;
import com.geoway.vtile.dataschema.datasource.impl.MysqlDataSource;
import com.geoway.vtile.dataschema.datasource.impl.OgrDataSource;
import com.geoway.vtile.dataschema.datasource.impl.OracleDataSource;
import com.geoway.vtile.dataschema.datasource.impl.PostgresDataSource;
import com.geoway.vtile.dataschema.datasource.impl.SparkDataSource;
import com.geoway.vtile.dataschema.exception.BusinessException;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class DataSourceFactory {
    public static DataSource create(String url, String user, String password) throws SQLException, IOException {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new BusinessException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u8fde\u63a5\u53c2\u6570");
        }
        DataSource dataSource = null;
        DataSource.DataSourceType type = DataSourceFactory.getDbType(url);
        switch (type) {
            case postgres: 
            case postgre: {
                dataSource = new PostgresDataSource(url, user, password);
                break;
            }
            case kingbase: {
                dataSource = new KingbaseDataSource(url, user, password);
                break;
            }
            case highgo: {
                dataSource = new HighgoDataSource(url, user, password);
                break;
            }
            case mysql: {
                if (url.indexOf("serverTimezone") == -1) {
                    url = url.indexOf("?") == -1 ? url + "?serverTimezone=UTC" : url + "&serverTimezone=UTC";
                }
                dataSource = new MysqlDataSource(url, user, password);
                break;
            }
            case oracle: {
                dataSource = new OracleDataSource(url, user, password);
                break;
            }
            case spark: {
                dataSource = new SparkDataSource(url, user, password);
                break;
            }
            case ogr: {
                dataSource = new OgrDataSource(url.substring(url.lastIndexOf("://") + 3));
                break;
            }
            case hbase: {
                dataSource = new HbaseDataSource(url);
                break;
            }
        }
        return dataSource;
    }

    private static DataSource.DataSourceType getDbType(String url) {
        if (url.contains("postgresql")) {
            return DataSource.DataSourceType.postgres;
        }
        if (url.contains("mysql")) {
            return DataSource.DataSourceType.mysql;
        }
        if (url.contains("oracle")) {
            return DataSource.DataSourceType.oracle;
        }
        if (url.contains("kingbase8")) {
            return DataSource.DataSourceType.kingbase;
        }
        if (url.contains("http")) {
            return DataSource.DataSourceType.spark;
        }
        if (url.contains("highgo")) {
            return DataSource.DataSourceType.highgo;
        }
        if (url.startsWith("shp://")) {
            return DataSource.DataSourceType.ogr;
        }
        if (url.startsWith("gpkg://")) {
            return DataSource.DataSourceType.ogr;
        }
        if (url.startsWith("fgdb://")) {
            return DataSource.DataSourceType.ogr;
        }
        if (url.startsWith("hbase://") || url.startsWith("hdfs://")) {
            return DataSource.DataSourceType.hbase;
        }
        throw new BusinessException("\u8fde\u63a5\u53c2\u6570\u9519\u8bef\uff08\u4e0d\u652f\u6301\u7684\u6570\u636e\u6e90\uff09: " + url);
    }
}

