/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.datasource.impl;

import com.geoway.vtile.dataschema.dao.IRelationSpatialDao;
import com.geoway.vtile.dataschema.dao.impl.GaussSpatialDao;
import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.dataschema.datasource.impl.PostgresDataSource;
import com.geoway.vtile.dataschema.exception.BusinessException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaussDataSource
extends DataSource {
    private Logger logger = LoggerFactory.getLogger(PostgresDataSource.class);

    public GaussDataSource(String url, String user, String password) throws SQLException {
        super(url, user, password, DataSource.DataSourceType.gauss);
    }

    public GaussDataSource(String url, String user, String password, DataSource.DataSourceType type) throws SQLException {
        super(url, user, password, type);
    }

    public IRelationSpatialDao getDao() throws SQLException {
        Connection conn = this.getConnection();
        return new GaussSpatialDao(conn);
    }

    @Override
    public boolean isValid() {
        Connection conn = null;
        try {
            Class.forName(this.type.getDriver());
            conn = DriverManager.getConnection(this.url, this.user, this.password);
            String sql = "select 1";
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            rs.close();
            stmt.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            String message = "\u8fde\u63a5\u5931\u8d25\uff0c" + this.url;
            if (e instanceof PSQLException) {
                message = message + "    \u539f\u56e0\uff1a";
                message = message + e.getMessage();
            }
            throw new BusinessException(message);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

