/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dataschema.datasource.manager;

import com.geoway.vtile.dataschema.datasource.DataSource;
import com.geoway.vtile.dataschema.datasource.manager.DataSourceManager;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceCollector
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(DataSourceCollector.class);
    private static long IDLE_TIME = 60000L;

    protected static void start() {
        Thread t = new Thread(new DataSourceCollector());
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void run() {
        DataSource pool = null;
        String key2 = null;
        while (true) {
            Map<String, DataSource> pools = DataSourceManager.dsMap;
            Set poolsKeys = pools.keySet().stream().map(poolKey -> poolKey).collect(Collectors.toSet());
            for (String key2 : poolsKeys) {
                pool = DataSourceManager.getPool(key2);
                if (pool.getUpdateTime() + DataSourceManager.EXPIRED_TIMEOUT >= System.currentTimeMillis()) continue;
                this.logger.warn(pool.getUrl() + "/r/n\u8fde\u63a5\u6c60\u8fc7\u671f\uff0c\u5df2\u7ecf\u56de\u6536\uff01");
                DataSourceManager.clearOnly(key2);
                pool.close();
            }
            try {
                Thread.sleep(IDLE_TIME);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

