/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.gdal;

import com.geoway.vtile.commons.util.ThreadLocalMD5;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.gdal.gdal.gdal;
import org.gdal.osr.osr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GDALInitializer {
    static boolean initialized = false;
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String JNA_LIBRARY_PATH = "jna.library.path";
    private static final String JNI_LIBRARY_PATH = "jni.library.path";
    private static final String SYS_PATHS = "sys_paths";
    private static final String GDAL_JNI_WINDOWS = "gdalalljni.dll";
    private static final String GDAL_JNI_LINUX = "libgdalalljni.so";
    private static final String PROJ_DIR = "proj9" + File.separator + "share";
    private static Logger logger = LoggerFactory.getLogger(GDALInitializer.class);

    private static void addLibsToJavaLibraryPath(String tmpDirName) {
        try {
            System.setProperty(JAVA_LIBRARY_PATH, tmpDirName);
            System.setProperty(JNA_LIBRARY_PATH, tmpDirName);
            System.setProperty(JNI_LIBRARY_PATH, tmpDirName);
            GDALInitializer.addLibraryDir(tmpDirName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void uncompressFile(String resourcePath, String filename, String md5, String outputDir) throws IOException {
        File outputFile;
        assert (resourcePath != null);
        assert (!resourcePath.endsWith("/"));
        if (filename == null) {
            return;
        }
        String outFilename = filename;
        if (filename.contains("x64so")) {
            outFilename = filename.replace("x64so/", "");
        }
        if ((outputFile = new File(outputDir, outFilename)).exists()) {
            ThreadLocalMD5 threadLocalMD5 = new ThreadLocalMD5();
            threadLocalMD5.setBigFile(outputFile);
            String outputFileMd5 = threadLocalMD5.getMD5();
            if (md5.equalsIgnoreCase(outputFileMd5)) {
                return;
            }
        }
        logger.info("write {}", (Object)filename);
        String basePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
        assert (!basePath.endsWith("/"));
        String libraryResourcePath = basePath + "/" + filename;
        InputStream is = GDALInitializer.class.getResourceAsStream(libraryResourcePath);
        if (is == null) {
            throw new FileNotFoundException("resource \"" + libraryResourcePath + "\" not found");
        }
        outputFile.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            byte[] buffer = new byte[1024];
            int cpt = 0;
            while ((cpt = is.read(buffer)) != -1) {
                fos.write(buffer, 0, cpt);
            }
        }
        catch (IOException ex) {
            logger.error("could not write file {}", (Object)filename);
            ex.printStackTrace(System.err);
            throw ex;
        }
        finally {
            is.close();
        }
    }

    private static String sanitizeFileName(String filename) {
        if (filename == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        block3: for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static void copyFiles(String resourcesFilesPath, String[] filesWithMd5, String to) {
        for (String filenameWithMd5 : filesWithMd5) {
            if (StringUtils.isBlank((CharSequence)(filenameWithMd5 = GDALInitializer.sanitizeFileName(filenameWithMd5)))) continue;
            String[] fileInfo = filenameWithMd5.split(":");
            if (fileInfo.length != 2 || StringUtils.isBlank((CharSequence)fileInfo[0]) || StringUtils.isBlank((CharSequence)fileInfo[1])) {
                throw new RuntimeException("Dynamic dependency file info's format should be [filename:md5], the file info " + filenameWithMd5 + " does not meet the specification");
            }
            String fileName = fileInfo[0].trim();
            String md5 = fileInfo[1].trim();
            filenameWithMd5 = filenameWithMd5.trim();
            logger.info("checking {}", (Object)filenameWithMd5);
            try {
                GDALInitializer.uncompressFile(resourcesFilesPath, fileName, md5, to);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static void addLibraryDir(String libraryPath) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            int length = paths.length;
            for (int i = 0; i < length; ++i) {
                if (!libraryPath.equals(paths[i])) continue;
                return;
            }
            String[] tmp = new String[length + 1];
            System.arraycopy(paths, 0, tmp, 0, length);
            tmp[length] = libraryPath;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initLibraries() throws Exception {
        if (initialized) {
            return;
        }
        Class<GDALInitializer> clazz = GDALInitializer.class;
        synchronized (GDALInitializer.class) {
            if (initialized) {
                logger.info("gdal has already been initialized.");
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            logger.info("initialize gdal the shared libraries");
            File tmpFile = new File(System.getProperty("java.io.tmpdir"));
            if (!tmpFile.exists() && !tmpFile.isDirectory()) {
                throw new RuntimeException("java.io.tmpdir does not exists");
            }
            String osName = System.getProperty("os.name");
            logger.info("OS : {}", (Object)osName);
            String osArch = Platform.RESOURCE_PREFIX;
            logger.info("Architecture : {}", (Object)osArch);
            InputStream gdalversionProperties = GDALInitializer.class.getResourceAsStream("/gdalversion.properties");
            if (gdalversionProperties == null) {
                throw new RuntimeException("gdalversion.properties file not found in the build,  incorrect compile");
            }
            String version = null;
            Properties properties = new Properties();
            try {
                properties.load(gdalversionProperties);
                version = properties.getProperty("version");
            }
            catch (Exception ex) {
                throw new RuntimeException("failed to load gdalversion.properties :" + ex.getMessage(), ex);
            }
            if (version == null) {
                throw new RuntimeException("gdalversion.properties does not contain version key, incorrect build");
            }
            String resourcesFilesPath = "/sharedlibraries/" + version + "/" + osArch + "/files";
            InputStream resourceAsStream = GDALInitializer.class.getResourceAsStream(resourcesFilesPath);
            if (resourceAsStream == null) {
                throw new RuntimeException("architecture is not supported yet : " + resourcesFilesPath);
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8);){
                String isDocker;
                int b;
                StringBuilder sb = new StringBuilder();
                while ((b = inputStreamReader.read()) != -1) {
                    sb.append((char)b);
                }
                File outputDir = new File(tmpFile, "fgdbsharedlibs/" + version);
                if (Platform.isLinux() && "true".equals(isDocker = System.getenv("VTILE_DOCKER"))) {
                    outputDir = new File("/lib64");
                }
                outputDir.mkdirs();
                String outputDirAbsolutePath = outputDir.getAbsolutePath();
                GDALInitializer.addLibsToJavaLibraryPath(outputDirAbsolutePath);
                String libPath = System.getProperty(JAVA_LIBRARY_PATH) + System.getProperty("path.separator") + outputDirAbsolutePath;
                System.setProperty(JNA_LIBRARY_PATH, libPath);
                String[] filesWithMd5 = sb.toString().split(",");
                GDALInitializer.copyFiles(resourcesFilesPath, filesWithMd5, outputDirAbsolutePath);
                String gdalalljniPath = null;
                if (Platform.isWindows()) {
                    gdalalljniPath = outputDir + File.separator + GDAL_JNI_WINDOWS;
                } else if (Platform.isLinux()) {
                    gdalalljniPath = outputDir + File.separator + GDAL_JNI_LINUX;
                }
                if (gdalalljniPath == null) {
                    throw new RuntimeException("\u4e0d\u652f\u6301 " + osArch);
                }
                System.out.println("native-lib\u8def\u5f84\uff1a" + System.getProperty(JAVA_LIBRARY_PATH));
                logger.info("loading jni library: {}", (Object)gdalalljniPath);
                NativeLibrary.getInstance((String)gdalalljniPath);
                System.load(gdalalljniPath);
                GDALInitializer.loadConfig(outputDirAbsolutePath);
                initialized = true;
                logger.info("gdal \u521d\u59cb\u5316\u5b8c\u6210!");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void loadConfig(String outputDirPath) throws IOException {
        gdal.AllRegister();
        gdal.SetConfigOption((String)"GDAL_FILENAME_IS_UTF8", (String)"YES");
        String projDir = outputDirPath + File.separator + PROJ_DIR;
        File projFile = new File(projDir);
        if (!projFile.exists()) {
            throw new IOException("\u6ca1\u6709\u627e\u5230PROJ_DIR\u76ee\u5f55" + projDir);
        }
        logger.info("load proj {}", (Object)projDir);
        osr.SetPROJSearchPath((String)projDir);
    }
}

