/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.dao.IMongoDao;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import com.geoway.vtile.model.IBinaryContent;
import com.geoway.vtile.model.IDocumentAble;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public class AbstractMongoGridFSDao<T extends IBinaryContent & Idable<String> & IJsonable, Builder extends IJsonableBuilder<T> & DocumentableBuilder<T>>
implements IMongoDao<T> {
    protected MongoDatabase database;
    protected String idFieldName;
    protected GridFSBucket bucket;
    public String bucketName;
    protected Builder beanBuilder;

    public AbstractMongoGridFSDao(MongoDatabase mongoDatabase, String bucketName, String idFieldName, Builder builder) {
        this.database = mongoDatabase;
        this.idFieldName = idFieldName;
        this.bucketName = bucketName;
        this.bucket = GridFSBuckets.create((MongoDatabase)mongoDatabase, (String)bucketName);
        this.beanBuilder = builder;
    }

    @Override
    public List<T> find(Bson filter) {
        GridFSFindIterable it = this.bucket.find(filter);
        MongoCursor cursor = it.iterator();
        ArrayList<IBinaryContent> list = new ArrayList<IBinaryContent>();
        while (cursor.hasNext()) {
            GridFSFile f = (GridFSFile)cursor.next();
            Document doc = f.getMetadata();
            IBinaryContent bean = null;
            try {
                bean = (IBinaryContent)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            list.add(bean);
        }
        return list;
    }

    @Override
    public Long count(Bson filter) {
        return null;
    }

    @Override
    public Boolean exists(String id) {
        return this.findone(id) != null;
    }

    @Override
    public T findone(String id) {
        GridFSFindIterable it = this.bucket.find((Bson)new Document(this.idFieldName, (Object)id));
        GridFSFile f = (GridFSFile)it.first();
        if (f != null) {
            Document doc = f.getMetadata();
            IBinaryContent bean = null;
            try {
                bean = (IBinaryContent)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return (T)bean;
        }
        return null;
    }

    @Override
    public T findone(Bson filter) {
        GridFSFindIterable it = this.bucket.find(filter);
        GridFSFile f = (GridFSFile)it.first();
        if (f != null) {
            Document doc = f.getMetadata();
            IBinaryContent bean = null;
            try {
                bean = (IBinaryContent)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return (T)bean;
        }
        return null;
    }

    protected GridFSFile findoneGF(Bson filter) {
        GridFSFindIterable it = this.bucket.find(filter);
        return (GridFSFile)it.first();
    }

    @Override
    public void deleteone(String id) {
        GridFSFile fontgf = this.findoneGF((Bson)new Document(this.idFieldName, (Object)id));
        if (fontgf != null) {
            this.bucket.delete(fontgf.getObjectId());
        }
    }

    @Override
    public void updateOne(String id, T bean) {
        this.deleteone((String)((Idable)bean).getId());
        this.insertOne(bean);
    }

    @Override
    public void insertOne(T bean) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bean.getContent());
        GridFSUploadOptions options = new GridFSUploadOptions().chunkSizeBytes(Integer.valueOf(358400)).metadata(((IDocumentAble)bean).toDocument());
        this.bucket.uploadFromStream((String)((Idable)bean).getId(), (InputStream)bin, options);
    }

    public byte[] getContent(Bson filter) {
        GridFSFindIterable it = this.bucket.find(filter);
        GridFSFile file = (GridFSFile)it.first();
        byte[] content = new byte[]{};
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            this.bucket.downloadToStream(file.getObjectId(), (OutputStream)out);
            content = out.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }
}

