/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao;

import com.alibaba.druid.util.JdbcUtils;
import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.dao.IPostgresDao;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPostgresDao<T extends Idable<String> & IJsonable, Builder extends IJsonableBuilder<T> & DocumentableBuilder<T>>
implements IPostgresDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractPostgresDao.class);
    protected String idFieldName = "f_id";
    protected String jsonFieldName = "f_json";
    private static final String JSON_FLAG = "_json";
    protected Builder beanBuilder;
    protected DataSource dataSource;
    protected String tableName;

    public AbstractPostgresDao(DataSource dataSource, String tableName, Builder builder) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.beanBuilder = builder;
    }

    @Override
    public T findOne(String id) {
        String sql = "select * from " + this.tableName + " where " + this.idFieldName + " = ? limit 1";
        if (this.isJsonTable()) {
            try {
                List list = JdbcUtils.executeQuery((Connection)this.dataSource.getConnection(), (String)sql, Collections.singletonList(id));
                if (list.isEmpty()) {
                    return null;
                }
                Object json = ((Map)list.get(0)).get(this.jsonFieldName);
                Assert.isTrue((json != null ? 1 : 0) != 0);
                return (T)((Idable)this.beanBuilder.fromJson(json.toString()));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        try {
            List list = JdbcUtils.executeQuery((Connection)this.dataSource.getConnection(), (String)sql, Collections.singletonList(id));
            if (list.isEmpty()) {
                return null;
            }
            Map map = (Map)list.get(0);
            return this.mapToBean(map);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public T mapToBean(Map<String, Object> map) {
        throw new RuntimeException("\u672a\u91cd\u5199\u6b64\u51fd\u6570");
    }

    @Override
    public List<T> findAll() {
        String sql = "select * from " + this.tableName;
        if (this.isJsonTable()) {
            try {
                List list = JdbcUtils.executeQuery((Connection)this.dataSource.getConnection(), (String)sql, Collections.emptyList());
                ArrayList<Object> results = new ArrayList<Object>();
                for (Map map : list) {
                    Object json = map.get(this.jsonFieldName);
                    if (json == null) continue;
                    try {
                        results.add(this.beanBuilder.fromJson(json.toString()));
                    }
                    catch (Exception e) {
                        this.logger.warn(this.getClass().getName() + " : " + map.get(this.idFieldName) + " \u53cd\u5e8f\u5217\u5316\u5931\u8d25");
                        this.logger.warn("\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
                    }
                }
                return results;
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        try {
            List list = JdbcUtils.executeQuery((Connection)this.dataSource.getConnection(), (String)sql, Collections.emptyList());
            return list.stream().map(this::mapToBean).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteOne(String id) {
        if (this.isJsonTable()) {
            String sql = "delete from " + this.tableName + " where f_id = ?";
            try {
                int i = JdbcUtils.executeUpdate((Connection)this.dataSource.getConnection(), (String)sql, Collections.singletonList(id));
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u5220\u9664\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void updateOne(String id, T bean) {
        if (this.isJsonTable()) {
            String sql = "update " + this.tableName + " set f_json = ? where f_id = ?";
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(((IJsonable)bean).toJson());
                list.add(id);
                int i = JdbcUtils.executeUpdate((Connection)this.dataSource.getConnection(), (String)sql, list);
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void insertOne(T bean) {
        if (this.isJsonTable()) {
            String sql = "insert into " + this.tableName + " (f_id, f_json) values (?, ?)";
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(bean.getId());
                list.add(((IJsonable)bean).toJson());
                int i = JdbcUtils.executeUpdate((Connection)this.dataSource.getConnection(), (String)sql, list);
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isJsonTable() {
        return this.tableName.endsWith(JSON_FLAG);
    }

    @Override
    public Boolean exists(String id) {
        return this.findOne(id) != null;
    }
}

