/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.client;

import com.geoway.vtile.diagnose.GlobalMetrics;
import com.geoway.vtile.manager.ManagerFactory;
import com.geoway.vtile.manager.cell.ITileDataCellManager;
import com.geoway.vtile.manager.data_service.IDataServiceManager;
import com.geoway.vtile.manager.data_sources.IDataSourcesManager;
import com.geoway.vtile.manager.font.IFontManager;
import com.geoway.vtile.manager.node.INodeManager;
import com.geoway.vtile.manager.style.IStyleManager;
import com.geoway.vtile.manager.task.ITaskManager;
import com.geoway.vtile.manager.texture.ITextureManager;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.MongodbDataSourceManager;
import com.geoway.vtile.resources.datasource.db.DbDataSource;
import com.geoway.vtile.resources.datasource.db.JDBCPoolManager;
import com.geoway.vtile.service.mapserver.MapServerAccess;
import com.geoway.vtile.tools.AbnormalCheck.CpuCheck;
import com.geoway.vtile.tools.AbnormalCheck.MongoCheck;
import com.geoway.vtile.tools.redis.RedisCache;
import com.geoway.vtile.utils.MongoClientURI;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static Logger logger = LoggerFactory.getLogger((String)"Client");
    private static Client client;
    private String pgUrl;
    private String redisUrl;
    protected DataSource postgresDbPool = null;
    protected IDataSourcesManager dataSourcesManager;
    protected IDataServiceManager dataServiceManager;
    protected IVectorServiceManager vectorServiceManager;
    protected ITextureManager textureManager;
    protected IStyleManager styleManager;
    protected IFontManager fontManager;
    protected ITaskManager taskManager;
    protected ITileDataCellManager tileDataCellManager;
    protected INodeManager nodeManager;
    private Integer httpMaxTotal = Runtime.getRuntime().availableProcessors();

    public static Client getInstance() {
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Client create(String pgBuziDB, String redisUrl, String mapserverUrl) throws Exception {
        if (client != null) return client;
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (client != null) return client;
            client = new Client(pgBuziDB, redisUrl, mapserverUrl);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return client;
        }
    }

    private Client(String pgBuziDB, String redisUrl, String mapserverUrl) throws Exception {
        this.pgUrl = pgBuziDB;
        this.redisUrl = redisUrl;
        String trustStore = System.getenv("trustStore");
        String trustStorePassword = System.getenv("trustStorePassword");
        String keyStore = System.getenv("keyStore");
        String keyStorePassword = System.getenv("keyStorePassword");
        if (trustStore != null && trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
        if (keyStore != null && keyStorePassword != null) {
            System.setProperty("javax.net.ssl.keyStore", keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        CpuCheck.getInst().check();
        this.postgresDbPool = this.initPgClient(this.pgUrl);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{redisUrl})) {
            RedisCache.init(redisUrl);
        }
        String address = this.pgUrl.contains("?") ? StringUtils.substringBetween((String)this.pgUrl, (String)"@", (String)"?") : StringUtils.substringAfterLast((String)this.pgUrl, (String)"@");
        RedisCache redisCache = new RedisCache();
        String key = "clusterId";
        if (redisCache.exists(key)) {
            Object value = redisCache.get(key);
            if (!String.valueOf(value).equals(address)) {
                throw new RuntimeException("\u4e1a\u52a1\u5e93\u5730\u5740\u4e0d\u5339\u914d!\u8bf7\u68c0\u67e5postgres\u548credis\u5730\u5740\u662f\u5426\u5bf9\u5e94");
            }
        } else {
            redisCache.set(key, address);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.initManager();
        client = this;
    }

    private DataSource initPgClient(String pgUrl) throws Exception {
        if (StringUtils.isBlank((CharSequence)pgUrl)) {
            throw new RuntimeException("\u4e1a\u52a1\u5e93\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (pgUrl.startsWith("mongodb://")) {
            throw new RuntimeException("\u5f53\u524d\u7248\u672c\u4e0d\u518d\u652f\u6301mongodb\u4e1a\u52a1\u5e93\uff0c\u8bf7\u8bbe\u7f6e\u6b63\u786e\u7684\u4e1a\u52a1\u5e93\u5730\u5740\uff01");
        }
        int index = pgUrl.indexOf("://");
        int authStartIndex = index < 0 ? 0 : index + 3;
        int authEndIndex = pgUrl.lastIndexOf("@");
        String url = pgUrl.substring(authEndIndex + 1);
        String auth = StringUtils.substring((String)pgUrl, (int)authStartIndex, (int)authEndIndex);
        String user = StringUtils.substringBefore((String)auth, (String)":");
        String password = StringUtils.substringAfter((String)auth, (String)":");
        DbDataSource dbsrc = new DbDataSource("buzzdb", url, user, password, Constants.DATA_SOURCE_TYPE.postgreSQL);
        DataSource ds = JDBCPoolManager.getInstance().getPool(dbsrc);
        return ds;
    }

    public Client(String pgUrl, String redisUrl, String mapserverUrl, boolean isDebug) throws Exception {
        if (!isDebug) {
            throw new Exception("\u6b64\u6784\u9020\u51fd\u6570\u53ea\u80fd\u7528\u4e8eDEBUG\u6a21\u5f0f, isDebug\u5fc5\u987b\u4e3atrue");
        }
        this.postgresDbPool = this.initPgClient(pgUrl);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{redisUrl})) {
            RedisCache.init(redisUrl);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
        this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
        this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
        this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
    }

    public void initManager() throws Exception {
        try {
            ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
            this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
            this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
            this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
            this.textureManager = ManagerFactory.getManager(ITextureManager.class, this);
            this.styleManager = ManagerFactory.getManager(IStyleManager.class, this);
            this.fontManager = ManagerFactory.getManager(IFontManager.class, this);
            this.tileDataCellManager = ManagerFactory.getManager(ITileDataCellManager.class, this);
            this.nodeManager = ManagerFactory.getManager(INodeManager.class, this);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public MongoDatabase initMongoClient(String uri) {
        MongoClient mongoClient;
        MongoCheck.getInst(uri).check();
        try {
            mongoClient = MongodbDataSourceManager.aquireMongoClient((String)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        return mongoClient.getDatabase(mongoClientURI.getDatabase());
    }

    public IVectorServiceManager getVectorServiceManager() {
        return this.vectorServiceManager;
    }

    public IDataSourcesManager getDataSourcesManager() {
        return this.dataSourcesManager;
    }

    public IDataServiceManager getDataServiceManager() {
        return this.dataServiceManager;
    }

    public ITextureManager getTextureManager() {
        return this.textureManager;
    }

    public IStyleManager getStyleManager() {
        return this.styleManager;
    }

    public IFontManager getFontManager() {
        return this.fontManager;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    public ITileDataCellManager getTileDataCellManager() {
        return this.tileDataCellManager;
    }

    public INodeManager getNodeManager() {
        return this.nodeManager;
    }

    public String getRedisUrl() {
        return this.redisUrl;
    }

    public DataSource getPostgresDB() {
        return this.postgresDbPool;
    }

    public MapServerAccess getMapServerAccess() {
        return new MapServerAccess(this.httpMaxTotal, 180000);
    }

    public HashMap<String, Object> getPoolMetrics() {
        try {
            LinkedHashMap<String, Object> poolMetrics = new LinkedHashMap<String, Object>();
            poolMetrics.put("mgpools", MongodbDataSourceManager.getMgpoolMetrics());
            poolMetrics.put("dbpools", JDBCPoolManager.getDruidpoolMetrics());
            ForkJoinPool tpool = ForkJoinPool.commonPool();
            HashMap<String, Integer> poolStat = new HashMap<String, Integer>();
            poolStat.put("parallelism", tpool.getParallelism());
            poolStat.put("workersCount", tpool.getPoolSize());
            poolStat.put("runingCount", tpool.getActiveThreadCount());
            poolStat.put("waitingCount", (int)tpool.getQueuedTaskCount());
            poolStat.put("stealCount", (int)tpool.getStealCount());
            poolMetrics.put("commonThreadPool", poolStat);
            poolMetrics.put("globalMetrics", GlobalMetrics.Current);
            return poolMetrics;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

