/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service;

import com.geoway.vtile.commons.conf.CacheConfig;
import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.netty.websocket.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServer {
    private static Logger LOG = LoggerFactory.getLogger(MetaServer.class);
    private static AppConfig _config;
    private static Client _client;

    public static void main(String[] args) {
        try {
            MetaServer.setUp(args);
            MetaServer.launchWSService();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void setUp(String[] args) throws Exception {
        System.out.println("=== parsing config ===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        CacheConfig.ENABLE_META_HTABLE_CACHE = true;
        AppConfig conf = new AppConfig();
        conf.loadConfig(args);
        _config = conf;
        _client = Client.create(conf.pgBuziDB, conf.redisUrl, conf.mapserverUrl);
        System.out.println("=== config completed ===");
    }

    private static void launchWSService() throws Exception {
        int wsTcpPort = MetaServer._config.wsPort;
        LOG.info("\u51c6\u5907\u5f00\u542fWebSocket\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + wsTcpPort);
        new WebSocketServer(_client).bind(wsTcpPort);
    }

    public static class AppConfig {
        public String buziPgUrl = "";
        public String buziPgUser = "";
        public String buziPgPwd = "";
        public String basecfgFile = "";
        public String pgBuziDB = "jdbc:postgresql://atlas_cicd:gOxCb*&IGuF7@whpg12.geoway.net:5432/atlas_server_ywk_cicd?useUnicode=true&characterEncoding=utf8";
        public String redisUrl = "redis://127.0.0.1:6379";
        public String mapserverUrl = "http://172.16.83.221:8091/mapserver";
        public int wsPort = 3000;

        public void loadConfig(String[] args) {
            int n = args.length;
            block7: for (int i = 0; i < n; ++i) {
                LOG.info("\u53c2\u6570" + i + ": " + args[i]);
                switch (i + 1) {
                    case 1: {
                        this.basecfgFile = args[i];
                        continue block7;
                    }
                    case 2: {
                        this.pgBuziDB = args[i];
                        continue block7;
                    }
                    case 3: {
                        this.redisUrl = args[i];
                        continue block7;
                    }
                    case 4: {
                        this.mapserverUrl = args[i];
                        continue block7;
                    }
                    case 5: {
                        this.wsPort = Integer.parseInt(args[i]);
                    }
                }
            }
            System.out.println("=================");
        }
    }
}

