/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tools.AbnormalCheck;

import com.geoway.vtile.tools.AbnormalCheck.AbstractCheck;
import com.geoway.vtile.tools.AbnormalCheck.IAbnormalCheck;
import com.geoway.vtile.tools.net.NetUtils;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisCheck
extends AbstractCheck
implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(RedisCheck.class);
    private static RedisCheck inst;
    private final Integer CONNECT_TIME_OUT = 1000;
    private String uri;

    public RedisCheck(String uri) {
        this.uri = uri;
    }

    public static RedisCheck getInst(String uri) {
        if (inst == null) {
            inst = new RedisCheck(uri);
        } else {
            RedisCheck.inst.uri = uri;
        }
        return inst;
    }

    @Override
    public void check() {
        String ip = "127.0.0.1";
        int port = 6379;
        try {
            URI uri = new URI(this.uri);
            ip = uri.getHost();
            port = uri.getPort();
        }
        catch (Exception e) {
            logger.error("Redis Uri \u5730\u5740\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01" + this.uri);
            super.shutdown();
        }
        Boolean isConnect = NetUtils.testIpAndPort(ip, port, this.CONNECT_TIME_OUT);
        if (!isConnect.booleanValue()) {
            logger.error("Redis \u670d\u52a1\u65e0\u6cd5\u8fde\u63a5");
            logger.error("1.\u8bf7\u6392\u67e5Redis\u670d\u52a1\u662f\u5426\u6b63\u5e38\u542f\u52a8");
            logger.error("2.\u68c0\u67e5\u7f51\u7edcip/\u7aef\u53e3\u662f\u5426\u5f00\u653e: " + ip + ":" + port);
            super.shutdown();
        }
        try (Jedis jedis = new Jedis(this.uri);){
            String ping = jedis.ping();
            if (!ping.equalsIgnoreCase("PONG")) {
                throw new Exception("Redis \u68c0\u67e5\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("Redis\u8fde\u63a5\u4e0d\u53ef\u7528\uff0c\u8bf7\u68c0\u67e5\u8fde\u63a5\u53c2\u6570\u662f\u5426\u6b63\u786e\uff1f" + this.uri);
        }
    }
}

