/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.model.data_service;

import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IMarkable;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.model.IBeanShell;
import com.geoway.vtile.model.ICanStartStop;
import com.geoway.vtile.model.IDocumentAble;
import com.geoway.vtile.model.IService;
import com.geoway.vtile.model.IVersionAble;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.data_service.DataServiceShell;
import com.geoway.vtile.model.data_service.FieldsConfig;
import com.geoway.vtile.model.data_service.tileInfo.IAreaTileInfo;
import com.geoway.vtile.model.data_service.tileInfo.IFeatureTileInfo;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.resources.datatable.IField;
import com.geoway.vtile.resources.datatable.ISpatialField;
import com.geoway.vtile.resources.datatable.ITable;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.spatial.Constants;
import java.util.List;
import java.util.Map;

public interface IDataService
extends IService,
IJsonable,
IMarkable,
Idable<String>,
IDocumentAble,
ICanStartStop,
IVersionAble,
IBeanShell<DataServiceBean> {
    public List<FieldsConfig> getFields();

    public IDataSourceInService getDataSource();

    public String getDataSourceId();

    public Boolean getReadOnly();

    public Map<String, IField> getFieldMap();

    public ISpatialField getSpatialField();

    public ISpatialField getSpatialFieldByTable();

    public Constants.GEO_TYPE getGeoType();

    public String getSpatialFieldOriName();

    public String getSpatialFieldName();

    public FieldsConfig getIdField();

    public String getIdFieldName();

    public Map<String, String> getAliasMap();

    public String[] getAliasFiledArr();

    public String getTableName();

    public String getName();

    public ITable getTable() throws Exception;

    public void refresh();

    public static IDataService create(Client client, DataServiceBean dataService) {
        return new DataServiceShell(client, dataService);
    }

    public void addStorageInfo(IStorageInfo var1);

    public IStorageInfo getStorageInfo();

    public IAreaTileInfo getAreaTileInfo();

    public void addAreaTileInfo(IAreaTileInfo var1);

    public IFeatureTileInfo getFeatureTileInfo();

    public void addFeatureTileInfo(IFeatureTileInfo var1);

    public String getStorageName();

    public String getAreaStorageName();

    public String getFeatureStorageName();

    public String getLabelStorageName();

    public Client getClient();

    public void setFilter(String var1);
}

