/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.style.StyleDao;
import com.geoway.vtile.exception.NotFoundException;
import com.geoway.vtile.manager.abstractclass.AbstractManager;
import com.geoway.vtile.manager.style.IStyleManager;
import com.geoway.vtile.manager.style.StyleInValidException;
import com.geoway.vtile.model.style.IStyleService;
import com.geoway.vtile.model.style.StyleBean;
import com.geoway.vtile.model.style.StyleBuilder;
import com.geoway.vtile.service.mapserver.MapServerAccess;
import com.geoway.vtile.service.mapserver.MapserverAccessException;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleManager
extends AbstractManager<IStyleService, StyleBuilder>
implements IStyleManager {
    private static Logger logger = LoggerFactory.getLogger(StyleManager.class);
    private static final long SYNC_TIMEOUT_MS = 5000L;
    protected static final String MANAGER_ROOT = "style";
    protected MapServerAccess mapServerAccess;

    public StyleManager() {
        super(StyleBuilder.getInstance(), MANAGER_ROOT);
        this.idFieldName = "uuid";
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.mapServerAccess = this.client.getMapServerAccess();
    }

    @Override
    public IMetaDataDao<IStyleService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            StyleDao styleDao = new StyleDao(this.idFieldName, (StyleBuilder)this.beanBuilder, (QueryHashTableHeap<String, IStyleService>)this.table, this.client, this.managerRoot, this.readOnly, this);
            styleDao.init();
            this.metaDataDao = styleDao;
        }
        return this.metaDataDao;
    }

    @Override
    public void save(IStyleService style) throws Exception {
        String result = null;
        try {
            IStyleService finalStyle = style;
            result = MapServerAccess.saveStyle(finalStyle.getOwnServer(), finalStyle.getName(), finalStyle.getStyleJson(), finalStyle.getXmin(), finalStyle.getYmin(), finalStyle.getXmax(), finalStyle.getYmax());
        }
        catch (MapserverAccessException e) {
            throw new CompletionException(e);
        }
        logger.debug(result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!(resultJson.containsKey((Object)"success") && resultJson.get((Object)"success").equals(true) && resultJson.containsKey((Object)"id"))) {
            throw new CompletionException("\u5730\u56fe\u6837\u5f0f\u5728\u5f15\u64ce\u7aef\u89e3\u6790\u4fdd\u5b58\u5931\u8d25", new StyleInValidException(resultJson.getString("message")));
        }
        long t1 = System.currentTimeMillis();
        String id = (String)style.getId();
        for (int i = 0; i < 10 && System.currentTimeMillis() - t1 <= 5000L; ++i) {
            try {
                logger.info("\u4fdd\u5b58\u6837\u5f0fing\uff0c\u91cd\u8bd5\u83b7\u53d6redis\u5143\u6570\u636e\u3002\u3002\u3002");
                style = (IStyleService)this.metaDataDao.findOne(id);
                if (null != style) break;
                Thread.sleep(50L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == style) {
            long msRemain = 5000L - (System.currentTimeMillis() - t1);
            if (msRemain > 0L) {
                Thread.sleep(msRemain);
                style = (IStyleService)this.metaDataDao.findOne(id);
            }
            if (null == style) {
                throw new RuntimeException("\u590d\u67e5\u4e1a\u52a1\u5e93\u7f13\u5b58\u672a\u627e\u5230\u5730\u56fe\u6837\u5f0f\u5143\u6570\u636e\uff1a" + id + "\u3002\u53ef\u80fd\u6837\u5f0f\u7f13\u5b58\u540c\u6b65\u6548\u7387\u8f83\u4f4e\uff0c\u5efa\u8bae\u4f18\u5316\u7f13\u5b58\u7cfb\u7edf\uff01");
            }
        }
        if (this.table.get((Serializable)((Object)id)) == null) {
            this.saveBeanToHashTable(style);
        } else {
            this.updateBeanToHashTable(style);
        }
        StyleDao styleDao = (StyleDao)this.metaDataDao;
        if (styleDao.existsInBusiDB(id)) {
            styleDao.update2Pg(style);
        } else {
            styleDao.insert2Pg(style);
        }
    }

    @Override
    public void remove(String[] ids) throws Exception {
        for (int i = 0; i < ids.length; ++i) {
            try {
                super.doRemove(ids[i]);
                continue;
            }
            catch (NotFoundException e) {
                logger.warn("\u5220\u9664\u6837\u5f0f" + ids[i] + "\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    @Override
    public IStyleService get(String belongService, String styleName) {
        return (IStyleService)super.get(belongService + "_" + styleName);
    }

    @Override
    public boolean checkVersion(String belongService, String styleName, String version) {
        IStyleService style = this.get(belongService, styleName);
        if (style != null) {
            return Objects.equals(version, style.getVersion());
        }
        return false;
    }

    @Override
    public void update(IStyleService style) throws Exception {
        this.remove(new String[]{style.getUuid()});
        ((StyleBean)style.getBean()).setUuid(style.getOwnServer() + "_" + style.getName());
        this.doAdd(style);
    }
}

