/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tools;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.datasource.spark.SparkDataSource;
import com.geoway.vtile.entity.DataSourceAccessBean;
import com.geoway.vtile.entity.DataSourceType;
import com.geoway.vtile.entity.DatasourceEntity;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.datasource.IDataSource;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DbDataSource;
import com.geoway.vtile.utils.MongoClientURI;
import java.lang.reflect.Constructor;

public class DataSourceBeanUtil {
    public static IDataSource convert(DatasourceEntity entity) throws Exception {
        DataSourceAccessBean conn = (DataSourceAccessBean)JSON.parseObject((String)JSON.parseObject((String)entity.getF_connection_content()).getString("value"), DataSourceAccessBean.class);
        String url = conn.getAddress();
        if (DataSourceType.MONGODB.getCode() == entity.getF_type().intValue()) {
            MongodbDataSource source = null;
            if (url.startsWith("mongodb://")) {
                source = new MongodbDataSource(url);
                source.setId(entity.getF_id());
            } else {
                url = url.startsWith("mongodb://") ? url : "mongodb://" + url;
                MongoClientURI uri = new MongoClientURI(url);
                String[] host = ((String)uri.getHosts().get(0)).split(":");
                Integer port = host.length > 1 ? Integer.parseInt(host[1]) : 80;
                source = new MongodbDataSource(entity.getF_id(), host[0], port, conn.getUser(), conn.getPassword(), uri.getDatabase());
            }
            return source;
        }
        if (DataSourceType.SPARK.getCode() == entity.getF_type().intValue()) {
            return new SparkDataSource(url, entity.getF_id());
        }
        if (DataSourceType.HBASE.getCode() == entity.getF_type().intValue()) {
            DataSourceBeanUtil.checkHBaseAvailable();
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.geoway.vtile.resources.datasource.hbase.HbaseDatasource");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u672a\u5f15\u5165resources.hbase\u76f8\u5173jar\u5305\uff01");
            }
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
            IDataSource hbaseSrc = (IDataSource)constructor.newInstance(url, entity.getF_id());
            return hbaseSrc;
        }
        if (DataSourceType.FGDB.getCode() == entity.getF_type().intValue()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.geoway.vtile.datasource.ogr.FGDBDataSource");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u672a\u5f15\u5165ogr\u6240\u9700jar\u5305");
            }
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
            IDataSource fgdbDataSource = (IDataSource)constructor.newInstance(entity.getF_id(), url);
            return fgdbDataSource;
        }
        if (DataSourceType.SHP.getCode() == entity.getF_type().intValue()) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.geoway.vtile.datasource.ogr.ShapeDataSource");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("\u672a\u5f15\u5165ogr\u6240\u9700jar\u5305");
            }
            Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
            IDataSource shapeDataSource = (IDataSource)constructor.newInstance(entity.getF_id(), url);
            return shapeDataSource;
        }
        DbDataSource source = new DbDataSource(entity.getF_id(), url, conn.getUser(), conn.getPassword(), null);
        if (DataSourceType.POSTGRESQL.getCode() == entity.getF_type().intValue()) {
            source.setDataSourceType(Constants.DATA_SOURCE_TYPE.postgreSQL);
        } else if (DataSourceType.MYSQL.getCode() == entity.getF_type().intValue()) {
            source.setDataSourceType(Constants.DATA_SOURCE_TYPE.mysql);
        } else if (DataSourceType.ORACLE.getCode() == entity.getF_type().intValue()) {
            source.setDataSourceType(Constants.DATA_SOURCE_TYPE.oracle);
        } else if (DataSourceType.KINGBASE.getCode() == entity.getF_type().intValue()) {
            source.setDataSourceType(Constants.DATA_SOURCE_TYPE.kingbase);
        } else if (DataSourceType.HIGHGO.getCode() == entity.getF_type().intValue()) {
            source.setDataSourceType(Constants.DATA_SOURCE_TYPE.highgo);
        }
        return source;
    }

    public static void checkHBaseAvailable() {
        try {
            Class<?> clazz = Class.forName("com.geoway.atlas.gis.toolkit.meta.api.AtlasGisToolkitApi");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u6807\u51c6\u7248\u4e0d\u652f\u6301HBase\uff0c\u8bf7\u4f7f\u7528\u77e2\u91cf\u74e6\u7247\u9ad8\u7ea7\u7248\u672c\uff0c\u5e76\u5b89\u88c5HBase\u6269\u5c55\u6a21\u5757\uff01");
        }
    }
}

