/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.xmlloader.vectorservice;

import com.geoway.vtile.commons.reflect.Bean;
import com.geoway.vtile.commons.util.MD5;
import com.geoway.vtile.manager.data_service.IDataServiceManager;
import com.geoway.vtile.model.data_service.DataServiceBean;
import com.geoway.vtile.model.data_service.DataServiceShell;
import com.geoway.vtile.model.data_service.IDataService;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.dataset.DataSetBean;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.datasource.IDataSource;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.resources.datasource.db.DbDataSource;
import com.geoway.vtile.resources.datatable.operate.IColumn;
import com.geoway.vtile.resources.datatable.operate.ITableOperator;
import com.geoway.vtile.service.client.Client;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.xml.sax.SAXException;

public abstract class AbstractXmlLoader {
    protected Client client;
    protected String validateXMLPath;

    protected abstract String getValidateXMLPath();

    protected AbstractXmlLoader(Client client) {
        this.client = client;
    }

    protected IDataSource createDataSource(Element info) {
        String type = this.getString(info, "Type");
        String id = info.attributeValue("Id");
        String url = this.getString(info, "Url");
        String user = this.getString(info, "User");
        String password = this.getString(info, "Password");
        if ("oracle".equalsIgnoreCase(type) || "postgres".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type) || "postgreSQL".equalsIgnoreCase(type)) {
            DbDataSource dbDataSource = new DbDataSource(id, url, user, password, null);
            if ("oracle".equalsIgnoreCase(type)) {
                dbDataSource.setDataSourceType(Constants.DATA_SOURCE_TYPE.oracle);
            }
            if ("postgres".equalsIgnoreCase(type) || "postgre".equalsIgnoreCase(type) || "postgreSQL".equalsIgnoreCase(type)) {
                dbDataSource.setDataSourceType(Constants.DATA_SOURCE_TYPE.postgreSQL);
            }
            if ("mysql".equalsIgnoreCase(type)) {
                dbDataSource.setDataSourceType(Constants.DATA_SOURCE_TYPE.mysql);
            }
            return dbDataSource;
        }
        if ("mongodb".equalsIgnoreCase(type)) {
            Integer port;
            MongodbDataSource mongodbDataSource = new MongodbDataSource(null, null, null, null, password, null);
            this.getInfoByStr(info, mongodbDataSource, "Ip,Namespace,Id,User");
            try {
                port = this.getInteger(info, "Port");
            }
            catch (Exception e) {
                port = null;
            }
            if (port == null) {
                try {
                    port = this.getInteger(info, "Post");
                }
                catch (Exception e) {
                    port = null;
                }
            }
            if (port == null) {
                throw new RuntimeException("port\u5fc5\u987b\u975e\u7a7a\u4e14\u5fc5\u987b\u662f\u6574\u6570");
            }
            mongodbDataSource.setPort(port);
            return mongodbDataSource;
        }
        throw new RuntimeException("\u73b0\u5728\u4e0d\u652f\u6301 " + type + " \u7684\u6570\u636e\u5e93");
    }

    protected <T> void getInfoByStr(Element item, T t, String fieldsStr) {
        String[] fieldArr;
        for (String field : fieldArr = fieldsStr.split(",")) {
            String value = null;
            if ("Id".equalsIgnoreCase(field)) {
                value = item.attributeValue("Id");
                if (value == null) {
                    value = "_tmp";
                }
            } else {
                value = this.getString(item, field);
            }
            if (StringUtils.isNotBlank((CharSequence)value)) {
                value = value.trim();
            }
            field = field.substring(0, 1).toLowerCase() + field.substring(1);
            try {
                Bean.setSingleObjectValueByFieldName(t, (String)field, (Object)value);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u5904\u7406" + field + "\u51fa\u9519");
            }
        }
    }

    protected IDataService autoRegisterDBDataService(Element info, IDataSourceInService dataSourceInService, String id, String name) throws Exception {
        String tableName = this.getString(info, "Tablename");
        String spatialField = this.getString(info, "ShapeField");
        String originFields = this.getString(info, "Fields");
        String filter = this.getString(info, "SQLFilter");
        Boolean readonly = true;
        String[] fields = originFields.split(",");
        DataServiceBean dataService = new DataServiceBean(id, spatialField, dataSourceInService.getId(), tableName, readonly, fields, null);
        dataService.setFilter(filter);
        dataService.setName(name);
        IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
        DataServiceShell dataServiceShell = new DataServiceShell(this.client, dataService);
        if (dataServiceManager.get(id) != null) {
            dataServiceManager.unRegister(id);
        }
        dataServiceShell.start();
        try {
            dataServiceManager.register(dataServiceShell);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        return dataServiceShell;
    }

    protected DataSetBean createDataSet(DataServiceBean dataService, Element info) {
        String srid;
        String filter;
        String idInXML = info.attributeValue("Id");
        DataSetBean dataSet = new DataSetBean(idInXML, dataService.getId());
        String spatialFilter = this.getString(info, "SpatialFilter");
        if (StringUtils.isNotBlank((CharSequence)spatialFilter)) {
            dataSet.setSpatialFilter(spatialFilter);
        }
        if (StringUtils.isNotBlank((CharSequence)(filter = this.getString(info, "SQLFilter")))) {
            dataSet.setFilter(filter);
        }
        if (StringUtils.isNotBlank((CharSequence)(srid = this.getString(info, "Srid")))) {
            dataSet.setSrid(srid);
        }
        return dataSet;
    }

    private void checkVectorInfo(Element item, Map<String, IDataSourceInService> dataSourceMap) throws Exception {
        String[] fieldsArr;
        String dataSourceId = this.getString(item, "DataSource");
        IDataSourceInService dataSourceInService = dataSourceMap.get(dataSourceId);
        if (dataSourceInService == null) {
            throw new Exception(StringUtils.join((Object[])new String[]{"\u6ca1\u6709\u627e\u5230\u540d\u79f0\u4e3a ", dataSourceId, " \u7684\u6570\u636e\u6e90"}));
        }
        String idInXML = item.attributeValue("Id");
        String fields = this.getString(item, "Fields");
        String spatialFieldsName = this.getString(item, "ShapeField");
        String tableName = this.getString(item, "Tablename");
        ITableOperator tableBuilder = null;
        try {
            tableBuilder = dataSourceInService.getTableBuilder(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(String.format("dataset %s ,\u83b7\u53d6%s\u8868\u4fe1\u606f\u5931\u8d25,\u9519\u8bef\u4fe1\u606f\uff1a%s", idInXML, tableName, e.getMessage()));
        }
        for (String fieldName : fieldsArr = fields.split(",")) {
            if (tableBuilder.getColumnMap().get(fieldName) != null) continue;
            throw new Exception(String.format("dataset %s ,%s\u8868\u6ca1\u6709\u627e\u5230\u5b57\u6bb5 %s", idInXML, tableName, fieldName));
        }
        IColumn column = (IColumn)tableBuilder.getColumnMap().get(spatialFieldsName);
        if (column == null) {
            throw new Exception(String.format("dataset %s ,%s\u8868\u6ca1\u6709\u627e\u5230\u5b57\u6bb5 %s", idInXML, tableName, spatialFieldsName));
        }
        if (!column.isSpatial().booleanValue()) {
            throw new Exception(String.format("dataset %s ,%s\u8868,\u5b57\u6bb5 %s,\u4e0d\u662f\u7a7a\u95f4\u5b57\u6bb5", idInXML, tableName, spatialFieldsName));
        }
    }

    private DataSetBean getVectorDataSet(Element item, Map<String, IDataSourceInService> dataSourceMap) throws Exception {
        this.checkVectorInfo(item, dataSourceMap);
        String idInXML = item.attributeValue("Id");
        String dataSourceId = this.getString(item, "DataSource");
        IDataSourceInService dataSourceInService = dataSourceMap.get(dataSourceId);
        String fields = this.getString(item, "Fields");
        String id = StringUtils.join((Object[])new String[]{"autocreate_", idInXML, "@", dataSourceInService.mark(), "_", MD5.getMD5String((String)fields)});
        IDataService dataServiceShell = this.autoRegisterDBDataService(item, dataSourceInService, id, idInXML);
        DataServiceBean dataService = (DataServiceBean)dataServiceShell.getBean();
        return this.createDataSet(dataService, item);
    }

    protected Map<String, DataSetBean> getDataSetMap(Element root, Map<String, IDataSourceInService> dataSourceMap) throws Exception {
        LinkedHashMap<String, DataSetBean> dataSetMap = new LinkedHashMap<String, DataSetBean>();
        List items = root.element("DataSets").elements();
        for (Element item : items) {
            String type = this.getString(item, "Type");
            if (!StringUtils.isBlank((CharSequence)type) && !"vector".equalsIgnoreCase(type)) continue;
            DataSetBean dataSet = this.getVectorDataSet(item, dataSourceMap);
            dataSetMap.put(dataSet.getId(), dataSet);
        }
        return dataSetMap;
    }

    protected String getString(Element info, String elementName) {
        String valueStr = info.elementTextTrim(elementName);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            valueStr = info.attributeValue(elementName);
        }
        return valueStr;
    }

    protected Integer getInteger(Element info, String elementName) {
        String valueStr = this.getString(info, elementName);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return null;
        }
        try {
            Integer value = Integer.valueOf(valueStr);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("xml\u4e2d" + elementName + "\u5fc5\u987b\u662fInteger\u7c7b\u578b");
        }
    }

    protected Double getDouble(Element info, String elementName) {
        String valueStr = this.getString(info, elementName);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return null;
        }
        try {
            Double value = Double.valueOf(valueStr);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("xml\u4e2d" + elementName + "\u5fc5\u987b\u662fDouble\u7c7b\u578b");
        }
    }

    protected Boolean getBoolean(Element info, String elementName) {
        String valueStr = this.getString(info, elementName);
        if (StringUtils.isBlank((CharSequence)valueStr)) {
            return null;
        }
        try {
            Boolean value = Boolean.valueOf(valueStr);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("xml\u4e2d" + elementName + "\u5fc5\u987b\u662fBoolean\u7c7b\u578b");
        }
    }

    private void validateXMLSchema(InputStream inXMl) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(new File(this.getValidateXMLPath()));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(inXMl));
    }

    public void validateXML(InputStream inXMl) throws Exception {
        try {
            this.validateXMLSchema(inXMl);
            inXMl.markSupported();
        }
        catch (SAXException e1) {
            throw new Exception("xml\u683c\u5f0f\u9519\u8bef:" + e1.toString().replaceAll("org.xml.sax.SAXParseException;", ""));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("\u6ca1\u6709\u627e\u5230XML\u6821\u9a8c\u6587\u4ef6");
        }
        finally {
            inXMl.close();
        }
    }
}

