/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.xmlloader;

import com.geoway.vtile.commons.event.EventContainer;
import com.geoway.vtile.commons.event.IListener;
import com.geoway.vtile.exception.ReservedWordsConflictException;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.VectorServiceBean;
import com.geoway.vtile.model.vector_service.VectorServiceShell;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.xmlloader.RegisterXmlToServerMessage;
import com.geoway.vtile.service.xmlloader.vectorservice.VectorServiceLoader;
import java.io.InputStream;
import java.util.Arrays;

public class RegisterXmlToServer {
    protected Client client;
    protected EventContainer<IListener> eventContainer = new EventContainer();

    public RegisterXmlToServer(Client client) {
        this.client = client;
    }

    public IVectorService register(InputStream inXMl) throws Exception {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(inXMl);
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        this.client.getVectorServiceManager().register(VectorServiceShell2);
        return VectorServiceShell2;
    }

    public IVectorService register(InputStream inXMl, String[] reservedWords) throws Exception {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(inXMl);
        String serviceId = service.getId();
        if (Arrays.asList(reservedWords).contains(serviceId)) {
            throw new ReservedWordsConflictException("\u670d\u52a1ID " + serviceId + " \u4e0e\u7cfb\u7edf\u4fdd\u7559\u5b57\u51b2\u7a81");
        }
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        this.client.getVectorServiceManager().register(VectorServiceShell2);
        return VectorServiceShell2;
    }

    public void on(RegisterXmlToServerMessage.EVENT_TYPE type, RegisterXmlToServerMessage e) {
        this.eventContainer.addListener(type.name(), parameter -> e.fire(parameter[0]));
    }
}

