/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tools.redis;

import com.geoway.vtile.tools.AbnormalCheck.RedisCheck;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

public class RedisCache {
    private static Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static long SCAN_TIMEOUT = 60000L;
    private static JedisPool _pool = null;

    public static void init(String redisUrl) {
        JedisPool pool;
        RedisCheck.getInst(redisUrl).check();
        _pool = pool = new JedisPool(redisUrl);
    }

    protected String wrapKey(String key) {
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            String string = jedis.get(realKey);
            return string;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void set(String key, String strval) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            String string = jedis.set(realKey, strval);
        }
        catch (Exception ex) {
            logger.error("\u5199\u5165redis\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void publish(String topic, String eventInfo) {
        try (Jedis jedis = _pool.getResource();){
            jedis.publish(topic, eventInfo);
        }
        catch (Exception ex) {
            logger.error("redis\u53d1\u5e03\u6d88\u606f\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void subscribe(String topic, JedisPubSub handler) {
        try (Jedis jedis = _pool.getResource();){
            jedis.subscribe(handler, new String[]{topic});
            logger.info("\u8ba2\u9605\u6d88\u606f\u7ed3\u675f");
        }
        catch (Exception ex) {
            logger.error("redis\u53d1\u5e03\u6d88\u606f\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void subscribeAsync(String topic, JedisPubSub handler) {
        logger.info("subscribing redis topic: " + topic);
        Thread thd = new Thread(() -> this.subscribe(topic, handler));
        thd.setDaemon(true);
        thd.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            boolean bl = jedis.exists(realKey);
            return bl;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            boolean bl = jedis.del(realKey) > 0L;
            return bl;
        }
        catch (Exception ex) {
            logger.error("redis\u5220\u9664\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> scan(String keyWord) {
        try (Jedis jedis = _pool.getResource();){
            String pattern = StringUtils.isBlank((CharSequence)keyWord) ? null : "*" + keyWord + "*";
            long startTime = System.currentTimeMillis();
            ArrayList<String> allKeys = new ArrayList<String>();
            String cursor = "0";
            ScanParams params = new ScanParams();
            if (null != pattern) {
                params.match(pattern);
            }
            do {
                long cost;
                ScanResult scanResult = jedis.scan(cursor, params);
                cursor = scanResult.getCursor();
                List reslist = scanResult.getResult();
                if (null != reslist && reslist.size() > 0) {
                    allKeys.addAll(reslist);
                }
                if ((cost = System.currentTimeMillis() - startTime) <= SCAN_TIMEOUT) continue;
                logger.error("redis scan \u626b\u63cf\u8d85\u65f6");
                break;
            } while (!cursor.equals("0"));
            ArrayList<String> arrayList = allKeys;
            return arrayList;
        }
        catch (Exception ex) {
            logger.error("redis \u67e5\u8be2\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean listPush(String key, String val) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            boolean bl = jedis.rpush(realKey, new String[]{val}) > 0L;
            return bl;
        }
        catch (Exception ex) {
            logger.error("redis\u63d2\u5165\u5217\u8868\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> listDump(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            List dataList = jedis.lrange(realKey, 0L, -1L);
            jedis.del(realKey);
            List list = dataList;
            return list;
        }
        catch (Exception ex) {
            logger.error("redis\u5bfc\u51fa\u5217\u8868\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long setBatchAdd(String key, List<String> values) {
        if (null == values) return 0L;
        if (0 == values.size()) {
            return 0L;
        }
        try (Jedis jedis = _pool.getResource();){
            List<String> subList;
            String realKey = this.wrapKey(key);
            int total = values.size();
            int batchSize = 1000;
            if (total < batchSize) {
                long l2 = jedis.sadd(realKey, values.toArray(new String[0]));
                return l2;
            }
            long totalRet = 0L;
            for (int i = 0; i <= total / batchSize; totalRet += jedis.sadd(realKey, subList.toArray(new String[0])), ++i) {
                subList = values.subList(i * batchSize, Math.min((i + 1) * batchSize, total));
            }
            long l = totalRet;
            return l;
        }
        catch (Exception ex) {
            logger.error("redis\u63d2\u5165set\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object setPop(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            String string = jedis.spop(realKey);
            return string;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis set\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long setCount(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            long l = jedis.scard(realKey);
            return l;
        }
        catch (Exception ex) {
            logger.error("\u67e5\u8be2redis set\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long incr(String key) {
        try (Jedis jedis = _pool.getResource();){
            String realKey = this.wrapKey(key);
            long l = jedis.incr(realKey);
            return l;
        }
        catch (Exception ex) {
            logger.error("incr\u5931\u8d25\uff1a" + ex.getMessage(), (Throwable)ex);
            return -1L;
        }
    }
}

