/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.node;

import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.node.NodeDao;
import com.geoway.vtile.dao.statislog.StatisLogDao;
import com.geoway.vtile.manager.node.INodeManager;
import com.geoway.vtile.manager.node.observer.IObserver;
import com.geoway.vtile.manager.node.observer.NodeEventBus;
import com.geoway.vtile.model.node.INodeService;
import com.geoway.vtile.model.node.NodeBean;
import com.geoway.vtile.model.node.NodeQuery;
import com.geoway.vtile.model.node.NodeType;
import com.geoway.vtile.model.statislog.StatisticsLog;
import com.geoway.vtile.service.client.Client;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NodeManager
implements INodeManager {
    private Client client;
    private INodeService localNode;
    private IMetaDataDao<INodeService> metaDataDao;
    private StatisLogDao statislogDao;
    protected NodeEventBus<StatisticsLog> nodeEventBus;

    @Override
    public void setClient(Client client) throws Exception {
        this.client = client;
    }

    @Override
    public void init() throws Exception {
        this.metaDataDao = this.getMetaDataDao();
        this.nodeEventBus = new NodeEventBus();
        this.statislogDao = new StatisLogDao(this.nodeEventBus);
    }

    public IMetaDataDao<INodeService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            NodeDao dao = new NodeDao(this.client, this);
            dao.init();
            this.metaDataDao = dao;
        }
        return this.metaDataDao;
    }

    @Override
    public List<INodeService> list(NodeQuery query) {
        try {
            List<INodeService> list = this.metaDataDao.findAll();
            if (query != null && list != null && list.size() > 0) {
                list = list.stream().filter(item -> {
                    NodeBean nodeBean = (NodeBean)item.getBean();
                    if (nodeBean == null) {
                        return false;
                    }
                    if (query == null) {
                        return true;
                    }
                    if (query.getActive() != null && !query.getActive().equals(nodeBean.getActive())) {
                        return false;
                    }
                    if (query.getUrl() != null && !query.getUrl().equals(nodeBean.getUrl())) {
                        return false;
                    }
                    if (query.getName() != null && !query.getName().equals(nodeBean.getName())) {
                        return false;
                    }
                    return query.getType() == null || query.getType().equals((Object)nodeBean.getType());
                }).collect(Collectors.toList());
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean register(String type, String name, String url, Boolean isLocal) {
        try {
            INodeService node = INodeService.create(url, NodeType.valueOf(type), name);
            if (StringUtils.isBlank((CharSequence)((NodeBean)node.getBean()).getUrl())) {
                throw new RuntimeException("\u5730\u5740\u672a\u8bbe\u7f6e");
            }
            if (((NodeBean)node.getBean()).getType() == null) {
                throw new RuntimeException("\u8282\u70b9\u670d\u52a1\u7c7b\u578b\u672a\u8bbe\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)node.getName())) {
                throw new RuntimeException("\u540d\u79f0\u672a\u8bbe\u7f6e");
            }
            if (isLocal.booleanValue()) {
                this.localNode = node;
            }
            this.metaDataDao.insert(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean unRegister(String type, String name) {
        try {
            String id = type + "_" + name;
            this.metaDataDao.delete(id);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean online(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            ((NodeBean)node.getBean()).setActive(true);
            this.metaDataDao.update(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean offline(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            ((NodeBean)node.getBean()).setActive(false);
            this.metaDataDao.update(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean refresh(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            Boolean isActive = node.isActive();
            if (isActive.booleanValue()) {
                ((NodeBean)node.getBean()).setVersion(String.valueOf(System.currentTimeMillis()));
            }
            ((NodeBean)node.getBean()).setActive(isActive);
            this.metaDataDao.update(node);
            return ((NodeBean)node.getBean()).getActive();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public INodeService get(String type, String name) {
        try {
            return this.get(NodeType.valueOf(type), name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public INodeService get(NodeType type, String name) {
        try {
            String id = NodeBean.buildUUid(type, name);
            return this.metaDataDao.findOne(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJSON(NodeType type, String id) {
        return this.get(type, id).toJson();
    }

    @Override
    public List<INodeService> findAll() {
        return this.list(null);
    }

    @Override
    public INodeService findOne(NodeQuery queryFilter) {
        List<INodeService> list = this.list(queryFilter);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public INodeService getLocalNode() {
        return this.localNode;
    }

    @Override
    public boolean publishStatisticLog(StatisticsLog logData) {
        try {
            this.statislogDao.insert(logData);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addStatislogListener(IObserver<StatisticsLog> observer) {
        this.nodeEventBus.registerObserver(observer);
        if (1 == this.nodeEventBus.size()) {
            this.statislogDao.subscribe();
        }
    }

    @Override
    public void removeStatislogListener(IObserver<StatisticsLog> observer) {
        this.nodeEventBus.removeObserver(observer);
    }
}

