/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.service.netty.websocket;

import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.service.netty.websocket.WebSocketFrameHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslContext;

public class WebSocketServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final String WEBSOCKET_PATH = "/websocket";
    private final SslContext sslCtx;
    Client client;

    public WebSocketServerInitializer(SslContext sslCtx, Client client) {
        this.sslCtx = sslCtx;
        this.client = client;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(314572800)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WEBSOCKET_PATH, null, true, 314572800)});
        WebSocketFrameHandler handler = new WebSocketFrameHandler();
        handler.setClient(this.client);
        handler.init();
        pipeline.addLast(new ChannelHandler[]{handler});
    }
}

