/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.data_sources;

import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.data_sources.DataSourcesDao;
import com.geoway.vtile.exception.NotSupport;
import com.geoway.vtile.manager.abstractclass.AbstractManager;
import com.geoway.vtile.manager.abstractclass.IEventMessage;
import com.geoway.vtile.manager.data_service.IDataServiceManager;
import com.geoway.vtile.manager.data_sources.IDataSourcesManager;
import com.geoway.vtile.manager.vector_service.IVectorServiceManager;
import com.geoway.vtile.model.data_source.DataSourceBuilder;
import com.geoway.vtile.model.data_source.IDataSourceInService;
import com.geoway.vtile.model.vector_service.layer.ILayer;
import com.geoway.vtile.model.vector_service.layer.ILayerLevel;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.resources.datatable.dao.IScroll;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcesManager
extends AbstractManager<IDataSourceInService, DataSourceBuilder>
implements IDataSourcesManager {
    protected static final String MANAGER_ROOT = "data_sources";
    protected Logger logger = LoggerFactory.getLogger(DataSourcesManager.class);

    public DataSourcesManager() {
        super(DataSourceBuilder.getInstance(), MANAGER_ROOT);
    }

    protected void addListener() {
        this.on(IEventMessage.EVENT_TYPE.unRegister, (id, t) -> this.logger.info("\u6570\u636e\u6e90" + id + "\u5df2\u88ab\u5220\u9664"));
        this.on(IEventMessage.EVENT_TYPE.update, (id, t) -> {
            this.logger.info("\u6570\u636e\u6e90" + id + "\u5df2\u66f4\u65b0");
            t.resetConnection();
        });
    }

    @Override
    public void register(IDataSourceInService t) throws Exception {
        super.doAdd(t);
    }

    @Override
    public void unRegister(String id) throws Exception {
        super.doRemove(id);
    }

    @Override
    public void update(IDataSourceInService t) throws Exception {
        super.doUpdate(t);
        IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
        IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
        ArrayList vectorServices = new ArrayList();
        List<Object> dataServices = new ArrayList();
        if (t.getDataSourceType() == Constants.DATA_SOURCE_TYPE.mongodb) {
            QueryFilter cacheFilter = new QueryFilter();
            List cacheServices = vectorServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(vectorService -> vectorService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
            vectorServices.addAll(cacheServices);
            cacheFilter = new QueryFilter();
            List cacheList = dataServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(dataService -> dataService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
            dataServices.addAll(cacheList);
        } else {
            QueryFilter filter = new QueryFilter();
            filter.addFilter("dataSourceId", Constants.OPERATION.EQ, new Object[]{t.getId()});
            dataServices = dataServiceManager.list(filter);
        }
        List services = vectorServiceManager.list(new QueryFilter());
        List dataVectorServices = dataServices.stream().flatMap(dataService -> services.stream().filter(service -> {
            for (ILayer layer : service.getLayerMap().values()) {
                for (ILayerLevel level : layer.getLevelMap().values()) {
                    if (!((String)dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                    return true;
                }
            }
            return false;
        })).collect(Collectors.toList());
        if (!dataVectorServices.isEmpty()) {
            vectorServices.addAll(dataVectorServices);
        }
        for (int i = 0; i < vectorServices.size(); ++i) {
            vectorServiceManager.update(vectorServices.get(i));
        }
    }

    @Override
    public IScroll<IDataSourceInService> scroll(QueryFilter queryFilter) {
        return super.scroll(queryFilter);
    }

    @Override
    protected IMetaDataDao<IDataSourceInService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            DataSourcesDao metaDataDao = new DataSourcesDao(this.idFieldName, (DataSourceBuilder)this.beanBuilder, (QueryHashTableHeap<String, IDataSourceInService>)this.table, this.client, this.managerRoot, this.readOnly, this);
            metaDataDao.init();
            this.metaDataDao = metaDataDao;
        }
        return this.metaDataDao;
    }

    @Override
    public IDataSourceInService findOne(QueryFilter queryFilter) {
        queryFilter.setStart(Integer.valueOf(0));
        queryFilter.setLimit(Integer.valueOf(1));
        List iList = super.list(queryFilter);
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return (IDataSourceInService)iList.get(0);
    }

    @Override
    public boolean checkVersion(String id, String version) {
        return false;
    }

    @Override
    public void start(String id) throws Exception {
        throw new NotSupport();
    }

    @Override
    public void stop(String id) throws Exception {
        throw new NotSupport();
    }

    @Override
    public void rename(String id, String newName) throws Exception {
        throw new NotSupport();
    }
}

