/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao.font;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.dao.AbstractPostgresDao;
import com.geoway.vtile.entity.FontEntity;
import com.geoway.vtile.model.Constants;
import com.geoway.vtile.model.font.FontBean;
import com.geoway.vtile.model.font.FontBuilder;
import com.geoway.vtile.model.font.FontShell;
import com.geoway.vtile.model.font.IFontService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontPgDao
extends AbstractPostgresDao<IFontService, FontBuilder> {
    Logger logger = LoggerFactory.getLogger(FontPgDao.class);
    protected static final String TABLE_NAME = "tb_font";
    protected static final String LIST_QUERY_FIELDS = "tf.f_type, tf.f_font_style, tf.f_font_weight, tff.f_name as f_family_name, tff.*";
    protected static final String SINGLE_QUERY_FIELDS = "tf.f_content, tf.f_type, tf.f_font_style, tf.f_font_weight, tff.f_name as f_family_name, tff.*";

    public FontPgDao(DataSource dataSource, FontBuilder builder) {
        super(dataSource, TABLE_NAME, builder);
    }

    @Override
    public IFontService findOne(String id) {
        String sql = "select tf.f_content, tf.f_type, tf.f_font_style, tf.f_font_weight, tff.f_name as f_family_name, tff.*  from tb_font tf left join tb_font_family tff on tf.f_family_id = tff.f_id where tff.f_name || '.' || tf.f_type  = ? and tff.f_id is not null limit 1";
        try {
            List<Map<String, Object>> list = this.jdbcExecute(sql, Collections.singletonList(id));
            if (list.isEmpty()) {
                return null;
            }
            return this.mapToBean((Map)list.get(0));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<IFontService> findAll() {
        String sql = "select tf.f_type, tf.f_font_style, tf.f_font_weight, tff.f_name as f_family_name, tff.* from tb_font tf left join tb_font_family tff on tf.f_family_id = tff.f_id where tff.f_id is not null";
        try {
            List<Map<String, Object>> list = this.jdbcExecute(sql, Collections.emptyList());
            return list.stream().map(map -> this.mapToBean((Map)map)).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public IFontService mapToBean(Map<String, Object> map) {
        FontEntity font = (FontEntity)JSON.parseObject((String)JSON.toJSONString(map), FontEntity.class);
        Constants.FONT_FILE_TYPE mFileType = Constants.FONT_FILE_TYPE.valueOf(font.getF_type());
        Constants.FONT_STYLE mFontStyle = Constants.FONT_STYLE.valueOf(font.getF_font_style());
        Constants.FONT_WEIGHT mFontWeight = Constants.FONT_WEIGHT.valueOf(font.getF_font_weight());
        String fontId = font.getF_family_name() + "." + font.getF_type();
        FontBean fontBean = new FontBean();
        fontBean.setId(fontId);
        fontBean.setFamily(font.getF_family_name());
        fontBean.setFileType(mFileType);
        fontBean.setStyle(mFontStyle);
        fontBean.setWeight(mFontWeight);
        fontBean.setContent(font.getF_content());
        fontBean.setVersion(new Date().getTime() + "");
        fontBean.setDefaultFont(font.getF_is_default() == 1);
        fontBean.setBackendUnCommon(font.getF_backend_uncommon());
        fontBean.setForeendUnCommon(font.getF_foreend_uncommon());
        return new FontShell(fontBean);
    }

    @Override
    public Boolean exists(String id) {
        String sql = "select tf.f_content, tf.f_type, tf.f_font_style, tf.f_font_weight, tff.f_name as f_family_name, tff.*  from tb_font tf left join tb_font_family tff on tf.f_family_id = tff.f_id where tff.f_name || '.' || tf.f_type  = ? and tff.f_id is not null limit 1";
        try {
            List<Map<String, Object>> list = this.jdbcExecute(sql, Collections.singletonList(id));
            return !list.isEmpty();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u67e5\u8be2\u4e1a\u52a1\u5e93\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }
}

