/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.manager.texture;

import com.alibaba.fastjson.JSON;
import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.dao.texture.TextureDao;
import com.geoway.vtile.manager.abstractclass.AbstractManager;
import com.geoway.vtile.manager.texture.ITextureManager;
import com.geoway.vtile.model.texture.ITextureService;
import com.geoway.vtile.model.texture.TextureBean;
import com.geoway.vtile.model.texture.TextureBuilder;
import com.geoway.vtile.resources.command.Constants;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TextureManager
extends AbstractManager<ITextureService, TextureBuilder>
implements ITextureManager {
    protected static final String MANAGER_ROOT = "texture";

    public TextureManager() {
        super(TextureBuilder.getInstance(), MANAGER_ROOT);
    }

    @Override
    protected IMetaDataDao<ITextureService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            TextureDao metaDataDao = new TextureDao(this.idFieldName, (TextureBuilder)this.beanBuilder, (QueryHashTableHeap<String, ITextureService>)this.table, this.client, this.managerRoot, this.readOnly);
            metaDataDao.init();
            this.metaDataDao = metaDataDao;
        }
        return this.metaDataDao;
    }

    @Override
    public void add(List<ITextureService> textures) throws Exception {
        int i2;
        ITextureService texture = null;
        HashSet<String> inValidNames = new HashSet<String>();
        for (i2 = 0; i2 < textures.size(); ++i2) {
            texture = textures.get(i2);
            if (texture.isValid()) continue;
            inValidNames.add(texture.getName());
        }
        if (!inValidNames.isEmpty()) {
            String i2 = StringUtils.join(inValidNames, (String)",");
        }
        for (i2 = 0; i2 < textures.size(); ++i2) {
            texture = textures.get(i2);
            super.doAdd((IJsonable)textures.get(i2));
        }
    }

    @Override
    public void remove(String[] ids) throws Exception {
        for (int i = 0; i < ids.length; ++i) {
            super.doRemove(ids[i]);
        }
    }

    @Override
    public String listByIds(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return "[]";
        }
        ArrayList<ITextureService> texturesList = new ArrayList<ITextureService>();
        String[] idarr = ids.split(",");
        for (int i = 0; i < idarr.length; ++i) {
            String key = idarr[i];
            ITextureService bean = (ITextureService)this.table.get((Serializable)((Object)key));
            if (null == bean) continue;
            texturesList.add(bean);
        }
        if (0 == texturesList.size()) {
            return "[]";
        }
        List textureBeans = texturesList.stream().map(texture -> (TextureBean)texture.getBean()).collect(Collectors.toList());
        return JSON.toJSONString(textureBeans);
    }

    @Override
    public List<ITextureService> listTextures(String[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter(this.idFieldName, Constants.OPERATION.IN, (Object[])ids);
        List<ITextureService> texturesList = this.list(filter);
        return texturesList;
    }

    @Override
    public void clearDirty(String id) throws Exception {
        TextureDao dao = (TextureDao)this.getMetaDataDao();
        dao.clearDirty(id);
    }
}

