/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.entity;

import com.geoway.vtile.resources.Constants;

public enum DataSourceType {
    SQLITE("Sqlite", 0, "jdbc:sqlite://"),
    ORACLE("Oracle", 1, "jdbc:oracle:thin:@", Constants.DATA_SOURCE_TYPE.oracle),
    POSTGRESQL("PostgreSQL", 2, "jdbc:postgresql://", Constants.DATA_SOURCE_TYPE.postgreSQL, "public"),
    MYSQL("Mysql", 3, "jdbc:mysql://", Constants.DATA_SOURCE_TYPE.mysql),
    GB("GB", 4, "jdbc:sqlite://"),
    ARCGIS("ArcGIS", 5, ""),
    MBTILES("MBTiles", 6, ""),
    MONGODB("MongoDB", 7, "jdbc:mongodb://", Constants.DATA_SOURCE_TYPE.mongodb),
    TDT2("TDT2", 8, ""),
    BDB("BDB", 9, ""),
    OSS("OSS", 10, ""),
    DISK("\u78c1\u76d8", 11, ""),
    FGDB("FGDB", 12, "fgdb://", Constants.DATA_SOURCE_TYPE.fgdb),
    SHP("SHP", 13, "shp://", Constants.DATA_SOURCE_TYPE.shape),
    GPKG("GPKG", 14, "gpkg://", Constants.DATA_SOURCE_TYPE.gpkg),
    KINGBASE("KingBase", 21, "jdbc:kingbase8://", Constants.DATA_SOURCE_TYPE.kingbase),
    HIGHGO("Highgo", 22, "jdbc:highgo://", Constants.DATA_SOURCE_TYPE.highgo),
    SPARK("Spark", 31, "", Constants.DATA_SOURCE_TYPE.spark),
    HBASE("Hbase", 32, "", Constants.DATA_SOURCE_TYPE.hbase);

    private String name;
    private int code;
    private String prefix;
    private String defaultNamespace = "";
    private Constants.DATA_SOURCE_TYPE type;

    private DataSourceType(String name, int code, String prefix) {
        this.name = name;
        this.code = code;
        this.prefix = prefix;
    }

    private DataSourceType(String name, int code, String prefix, Constants.DATA_SOURCE_TYPE type) {
        this.name = name;
        this.code = code;
        this.prefix = prefix;
        this.type = type;
    }

    private DataSourceType(String name, int code, String prefix, Constants.DATA_SOURCE_TYPE type, String defaultNamespace) {
        this.name = name;
        this.code = code;
        this.prefix = prefix;
        this.type = type;
        this.defaultNamespace = defaultNamespace;
    }

    public String getName() {
        return this.name;
    }

    public int getCode() {
        return this.code;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Constants.DATA_SOURCE_TYPE getType() {
        return this.type;
    }

    public static String getDefaultNamespace(int code) {
        for (DataSourceType c : DataSourceType.values()) {
            if (c.getCode() != code) continue;
            return c.defaultNamespace;
        }
        return null;
    }

    public static String getName(int code) {
        for (DataSourceType c : DataSourceType.values()) {
            if (c.getCode() != code) continue;
            return c.name;
        }
        return null;
    }

    public static String getPrefix(int code) {
        for (DataSourceType c : DataSourceType.values()) {
            if (c.getCode() != code) continue;
            return c.prefix;
        }
        return null;
    }

    public static Integer getCode(Constants.DATA_SOURCE_TYPE type) {
        for (DataSourceType c : DataSourceType.values()) {
            if (c.getType() != type) continue;
            return c.code;
        }
        return null;
    }
}

