/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao.node;

import com.geoway.vtile.dao.IMetaDataDao;
import com.geoway.vtile.exception.NotSupport;
import com.geoway.vtile.manager.node.IMetaNodeManager;
import com.geoway.vtile.model.node.INodeService;
import com.geoway.vtile.model.node.NodeBuilder;
import com.geoway.vtile.resources.command.QueryFilter;
import com.geoway.vtile.service.client.Client;
import com.geoway.vtile.tools.redis.RedisCache;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDao
implements IMetaDataDao<INodeService> {
    private static Logger log = LoggerFactory.getLogger(NodeDao.class);
    public static String NS_MAPS = "node_mapserver";
    public static String NS_MANAGER = "node_manager";
    public static String NS_TILER = "node_tiler";
    protected Client client;
    protected RedisCache redis;

    public NodeDao(Client client, IMetaNodeManager<INodeService> manager) {
        this.client = client;
    }

    @Override
    public void init() throws Exception {
        this.redis = new RedisCache();
    }

    @Override
    public void sync2Redis(INodeService data) throws Exception {
        String id = data.getId();
        this.redis.set(this.wrapKey(id), data.toJson());
    }

    protected String wrapKey(String id) {
        String category = NS_MAPS;
        if (id.contains("_")) {
            int subIdx = id.indexOf("_");
            String strNodeType = id.substring(0, subIdx).toLowerCase();
            id = id.substring(subIdx + 1);
            if (strNodeType.length() > 0) {
                switch (strNodeType) {
                    case "mapserver": {
                        category = NS_MAPS;
                        break;
                    }
                    case "manager": {
                        category = NS_MANAGER;
                        break;
                    }
                    case "tiler": {
                        category = NS_TILER;
                        break;
                    }
                }
            }
        }
        return category + ":" + id;
    }

    @Override
    public void insert(INodeService data) throws Exception {
        this.sync2Redis(data);
    }

    @Override
    public void update(INodeService data) throws Exception {
        this.sync2Redis(data);
    }

    @Override
    public void delete(String id) throws Exception {
        this.redis.remove(this.wrapKey(id));
    }

    @Override
    public boolean exists(String id) throws Exception {
        return this.redis.exists(this.wrapKey(id));
    }

    @Override
    public List<INodeService> findAll() throws Exception {
        List<String> nodes = this.redis.scan("node_");
        ArrayList<INodeService> list = new ArrayList<INodeService>();
        for (String nodeKey : nodes) {
            String nodeStr = this.redis.get(nodeKey).toString();
            INodeService nodeService = NodeBuilder.getInstance().fromJson(nodeStr);
            list.add(nodeService);
        }
        return list;
    }

    @Override
    public INodeService findOne(String id) throws Exception {
        String json = (String)this.redis.get(this.wrapKey(id));
        INodeService nodeService = NodeBuilder.getInstance().fromJson(json);
        return nodeService;
    }

    @Override
    public List<INodeService> query(QueryFilter queryFilter) {
        throw new NotSupport();
    }
}

