/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.dao;

import com.alibaba.druid.util.JdbcUtils;
import com.geoway.vtile.bean.IJsonable;
import com.geoway.vtile.bean.IJsonableBuilder;
import com.geoway.vtile.bean.Idable;
import com.geoway.vtile.dao.IPostgresDao;
import com.geoway.vtile.manager.abstractclass.DocumentableBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.locationtech.jts.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPostgresDao<T extends Idable<String> & IJsonable, Builder extends IJsonableBuilder<T> & DocumentableBuilder<T>>
implements IPostgresDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractPostgresDao.class);
    protected String idFieldName = "f_id";
    protected String jsonFieldName = "f_json";
    private static final String JSON_FLAG = "_json";
    protected Builder beanBuilder;
    protected DataSource dataSource;
    protected String tableName;

    public AbstractPostgresDao(DataSource dataSource, String tableName, Builder builder) {
        this.dataSource = dataSource;
        this.tableName = tableName;
        this.beanBuilder = builder;
    }

    @Override
    public T findOne(String id) {
        List<Map<String, Object>> list;
        String sql;
        try {
            sql = this.dataSource.getConnection().getMetaData().getURL().startsWith("jdbc:derby") ? "select * from " + this.tableName + " where " + this.idFieldName + " = ? FETCH FIRST 1 ROWS ONLY" : "select * from " + this.tableName + " where " + this.idFieldName + " = ? limit 1";
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        try {
            list = this.jdbcExecute(sql, Collections.singletonList(id));
            if (list.isEmpty()) {
                return null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u67e5\u8be2\u4e1a\u52a1\u5e93\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
        try {
            if (this.isJsonTable()) {
                Object json = list.get(0).get(this.jsonFieldName);
                Assert.isTrue((json != null ? 1 : 0) != 0);
                return (T)((Idable)this.beanBuilder.fromJson(json.toString()));
            }
            Map<String, Object> map = list.get(0);
            return this.mapToBean(map);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public T mapToBean(Map<String, Object> map) {
        throw new RuntimeException("\u672a\u91cd\u5199\u6b64\u51fd\u6570");
    }

    @Override
    public List<T> findAll() {
        List<Map<String, Object>> list;
        String sql = "select * from " + this.tableName;
        try {
            list = this.jdbcExecute(sql, Collections.emptyList());
            if (list.isEmpty()) {
                return null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u67e5\u8be2\u4e1a\u52a1\u5e93\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
        try {
            if (this.isJsonTable()) {
                ArrayList<Object> results = new ArrayList<Object>();
                for (Map<String, Object> map : list) {
                    Object json = map.get(this.jsonFieldName);
                    if (json == null) continue;
                    try {
                        results.add(this.beanBuilder.fromJson(json.toString()));
                    }
                    catch (Exception e) {
                        this.logger.error(this.getClass().getName() + " : " + map.get(this.idFieldName) + " \u53cd\u5e8f\u5217\u5316\u5931\u8d25");
                        this.logger.error("\u9519\u8bef\u4fe1\u606f : " + e.getMessage());
                    }
                }
                return results;
            }
            return list.stream().map(this::mapToBean).collect(Collectors.toList());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteOne(String id) {
        if (this.isJsonTable()) {
            String sql = "delete from " + this.tableName + " where f_id = ?";
            try {
                int i = this.jdbcUpdate(sql, Collections.singletonList(id));
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u5220\u9664\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void updateOne(String id, T bean) {
        if (this.isJsonTable()) {
            String sql = "update " + this.tableName + " set f_json = ? where f_id = ?";
            try {
                ArrayList<String> list = new ArrayList<String>();
                list.add(((IJsonable)bean).toJson());
                list.add(id);
                int i = this.jdbcUpdate(sql, list);
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u66f4\u65b0\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void insertOne(T bean) {
        if (this.isJsonTable()) {
            String sql = "insert into " + this.tableName + " (f_id, f_json) values (?, ?)";
            try {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(bean.getId());
                list.add(((IJsonable)bean).toJson());
                int i = this.jdbcUpdate(sql, list);
                Assert.isTrue((i > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    protected List<Map<String, Object>> jdbcExecute(String sql, List parameters) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            List<Map<String, Object>> list = AbstractPostgresDao.executeQuery(conn, sql, parameters);
            return list;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6267\u884c\u4e1a\u52a1\u5e93\u67e5\u8be2\u51fa\u9519\uff1a" + ex.getMessage(), ex);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(Connection conn, String sql, List<Object> parameters) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            AbstractPostgresDao.setParameters(stmt, parameters);
            rs = stmt.executeQuery();
            ResultSetMetaData rsMeta = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                int size = rsMeta.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    String columName = rsMeta.getColumnLabel(i + 1);
                    Object value = rs.getObject(i + 1);
                    if (value instanceof Clob) {
                        try {
                            value = AbstractPostgresDao.clobToString((Clob)value);
                        }
                        catch (SQLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    row.put(columName, value);
                }
                rows.add(row);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close((Statement)stmt);
            throw throwable;
        }
        JdbcUtils.close((ResultSet)rs);
        JdbcUtils.close((Statement)stmt);
        return rows;
    }

    private static void setParameters(PreparedStatement stmt, List<Object> parameters) throws SQLException {
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            Object param = parameters.get(i);
            stmt.setObject(i + 1, param);
        }
    }

    private static String clobToString(Clob clob) throws SQLException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(clob.getCharacterStream());){
            int charsRead;
            char[] buffer = new char[4096];
            while ((charsRead = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, charsRead);
            }
        }
        catch (IOException e) {
            throw new SQLException("\u8bfb\u53d6 CLOB \u5931\u8d25", e);
        }
        return sb.toString();
    }

    protected int jdbcUpdate(String sql, List parameters) {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            int n = JdbcUtils.executeUpdate((Connection)conn, (String)sql, (List)parameters);
            return n;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6267\u884c\u4e1a\u52a1\u5e93\u66f4\u65b0\u51fa\u9519\uff1a" + ex.getMessage(), ex);
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean isJsonTable() {
        return this.tableName.endsWith(JSON_FLAG);
    }

    @Override
    public Boolean exists(String id) {
        try {
            String sql = this.dataSource.getConnection().getMetaData().getURL().startsWith("jdbc:derby") ? "select * from " + this.tableName + " where " + this.idFieldName + " = ? FETCH FIRST 1 ROWS ONLY" : "select * from " + this.tableName + " where " + this.idFieldName + " = ? limit 1";
            List<Map<String, Object>> list = this.jdbcExecute(sql, Collections.singletonList(id));
            return !list.isEmpty();
        }
        catch (Exception ex) {
            throw new RuntimeException("\u67e5\u8be2\u4e1a\u52a1\u5e93\u5931\u8d25\uff1a" + ex.getMessage(), ex);
        }
    }
}

