/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.resources.dialect.db.derby;

import com.geoway.vtile.commons.util.StringUtility;
import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.datatable.operate.ColumnBean;
import com.geoway.vtile.resources.dialect.ADialect;
import com.geoway.vtile.resources.dialect.ICreateTableFieldRefDialect;
import com.geoway.vtile.resources.dialect.IResourcesDataInput;
import com.geoway.vtile.resources.dialect.IResourcesDataOutput;
import com.geoway.vtile.resources.dialect.db.derby.DerbyFieldRefDialect;
import com.geoway.vtile.resources.dialect.db.derby.DerbyResourcesDataInput;
import com.geoway.vtile.resources.dialect.db.derby.DerbyResourcesDataOutput;
import com.geoway.vtile.resources.dialect.function.Function;
import com.geoway.vtile.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.geoway.vtile.resources.dialect.function.sql.SpatialFilterExpression;
import com.geoway.vtile.resources.dialect.sql.AbstractSQLDialect;
import com.geoway.vtile.resources.dialect.sql.ISQLDialect;
import com.geoway.vtile.type.Type;
import com.geoway.vtile.type.TypeBytes;
import com.geoway.vtile.type.TypeGaussGeometry;
import com.geoway.vtile.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

@ADialect(name="derby", type=Constants.DATA_SOURCE_TYPE.derby)
public class DerbyDialect
extends AbstractSQLDialect
implements ISQLDialect {
    public static DerbyDialect INSTANCE = new DerbyDialect();
    public static final String KEY_WORD_SERIAL = "serial";
    public static final String KEY_WORD_NOW_DATE = "current_timestamp";
    public static final String KEY_WORD_CURRENT_TIMESTAMP = "current_timestamp";
    public static final String KET_WORD_DEFAULT_SCHEMA = "public";
    public static final DerbyResourcesDataInput resourcesDataInput = new DerbyResourcesDataInput();
    public static final DerbyResourcesDataOutput resourcesDataOutput = new DerbyResourcesDataOutput();

    public DerbyDialect() {
        this.name = Constants.DATA_SOURCE_TYPE.derby.name();
    }

    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return Constants.DATA_SOURCE_TYPE.derby;
    }

    protected void registerTypes() {
        this.registerType((Type)Types.INTEGER, new String[]{"INTEGER", "SMALLINT"});
        this.registerClassType((Type)Types.INTEGER, new Class[]{Integer.class, Short.class});
        this.registerType((Type)Types.STRING, new String[]{"VARCHAR", "CHAR", "CLOB"});
        this.registerClassType((Type)Types.STRING, new Class[]{String.class});
        this.registerType((Type)Types.DOUBLE, new String[]{"DOUBLE PRECISION", "DOUBLE", "FLOAT"});
        this.registerClassType((Type)Types.DOUBLE, new Class[]{Double.class, Float.class});
        this.registerType((Type)Types.BIGDECIMAL, new String[]{"NUMERIC", "DECIMAL"});
        this.registerClassType((Type)Types.BIGDECIMAL, new Class[]{BigDecimal.class, BigInteger.class});
        this.registerType((Type)Types.TIME_STAMP, new String[]{"TIMESTAMP", "DATE", "TIME"});
        this.registerClassType((Type)Types.TIME_STAMP, new Class[]{Date.class});
        this.registerType((Type)Types.BOOLEAN, new String[]{"SMALLINT"});
        this.registerClassType((Type)Types.BOOLEAN, new Class[]{Boolean.class});
        this.registerType((Type)Types.LONG, new String[]{"BIGINT"});
        this.registerClassType((Type)Types.LONG, new Class[]{Long.class});
        this.registerType((Type)TypeBytes.INSTANCE, new String[]{"BLOB"});
        this.registerClassType((Type)TypeBytes.INSTANCE, new Class[]{byte[].class});
    }

    public String getSelfDesc() {
        return "derby\u65b9\u8a00";
    }

    protected void registerFunctions() {
        Type[] typeIn = new Type[]{TypeGaussGeometry.INSTANCE, TypeGaussGeometry.INSTANCE};
        this.registerFunction("intersects", (Function)new SQLSpatialRelateFunction("st_intersects", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("equals", (Function)new SQLSpatialRelateFunction("st_equals", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("contains", (Function)new SQLSpatialRelateFunction("st_contains", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("crosses", (Function)new SQLSpatialRelateFunction("st_crosses", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("disjoint", (Function)new SQLSpatialRelateFunction("st_disjoint", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("touches", (Function)new SQLSpatialRelateFunction("st_touches", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("within", (Function)new SQLSpatialRelateFunction("st_within", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("overlaps", (Function)new SQLSpatialRelateFunction("st_overlaps", (Type)Types.BOOLEAN, typeIn));
        this.registerFunction("mbr_intersects", (Function)new SpatialFilterExpression((Type)Types.BOOLEAN, typeIn));
    }

    public String getJDBCDriver() {
        return "org.apache.derby.jdbc.ClientDriver";
    }

    public String createConnectUrl(String url) {
        if (url.startsWith("jdbc:derby")) {
            return url;
        }
        return "jdbc:derby://" + url;
    }

    public Boolean markForTableNameAndColumnName() {
        return true;
    }

    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        connection.setAutoCommit(false);
        preparedStatement.setFetchSize(fetchSize);
        preparedStatement.setFetchDirection(1000);
    }

    public String getDefaultSchema() {
        return KET_WORD_DEFAULT_SCHEMA;
    }

    public Boolean isFieldSerial(String columnTypeName) {
        if (KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)) {
            return true;
        }
        return false;
    }

    protected boolean defaultValueIsSequence(String columnTypeName, String defaultValue) {
        if (this.isFieldSerial(columnTypeName).booleanValue()) {
            return false;
        }
        if (defaultValue == null) {
            return false;
        }
        if (defaultValue.startsWith("nextval(") && defaultValue.endsWith("::regclass)")) {
            return true;
        }
        return defaultValue.startsWith("nextval(".toUpperCase()) && defaultValue.endsWith("::regclass".toUpperCase());
    }

    protected boolean defaultValueIsFuntion(String columnTypeName, String defaultValue) {
        if (this.isFieldSerial(columnTypeName).booleanValue()) {
            return false;
        }
        return StringUtility.isFunction((String)defaultValue);
    }

    protected boolean defaultValueIsNowDate(String columnTypeName, String defaultValue) {
        return "current_timestamp".equalsIgnoreCase(defaultValue) || "current_timestamp".equalsIgnoreCase(defaultValue);
    }

    public String createSequenceName(String schema, String tableName, String fieldName) {
        StringBuilder seqName = new StringBuilder();
        if (schema != null && !KET_WORD_DEFAULT_SCHEMA.equalsIgnoreCase(schema)) {
            seqName.append(schema.toLowerCase()).append("_");
        }
        seqName.append(tableName).append("_");
        seqName.append(fieldName).append("_seq");
        return seqName.toString();
    }

    public String hasSequenceSql(String sequenceName) {
        String sql = "select relname from pg_class where relname = ?";
        return sql;
    }

    public String getCreateSequenceSQL(String sequenceName) {
        StringBuilder sql = new StringBuilder("CREATE SEQUENCE ").append(sequenceName).append(" ").append("INCREMENT 1 ").append("MINVALUE 0 ").append("MAXVALUE 9223372036854775807 ").append("START 0 ").append("CACHE 1 ");
        return sql.toString();
    }

    public ICreateTableFieldRefDialect<List<String>, String> getCreateTableFieldRefDialect() {
        return DerbyFieldRefDialect.INSTANCE;
    }

    public boolean isColumnSerial(ColumnBean columnBean, String columnTypeName) {
        return KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName);
    }

    public String processTableNameAndSchema(String tableName) {
        return tableName;
    }

    public IResourcesDataInput<PreparedStatement, Integer> getResourcesDataDataInput() {
        return resourcesDataInput;
    }

    public IResourcesDataOutput<ResultSet, Integer> getResourcesDataOutput() {
        return resourcesDataOutput;
    }
}

