/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.datatable.kingbase.operate;

import com.geoway.vtile.resources.Constants;
import com.geoway.vtile.resources.datatable.db.operate.AbstractDBTableOperator;
import com.geoway.vtile.resources.datatable.db.operate.IDBTableOperator;
import com.geoway.vtile.resources.datatable.db.operate.column.PostgresColumn;
import com.geoway.vtile.resources.datatable.operate.ATableOperator;
import com.geoway.vtile.resources.datatable.operate.IColumn;
import com.geoway.vtile.resources.datatable.operate.IIndex;
import com.geoway.vtile.resources.datatable.operate.Index;
import com.geoway.vtile.resources.sql.jdbc.IJDBCTransformer;
import com.geoway.vtile.spatial.Constants;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@ATableOperator(name="kingbase", type=Constants.DATA_SOURCE_TYPE.kingbase)
public class KingbaseTableOperator
extends AbstractDBTableOperator
implements IDBTableOperator {
    protected static final String DEFAULT_PG_SCHEMA = "public";

    protected void processTableNameAndSchema(String tableName, String schema, Boolean isCaseSensitive) {
        if (tableName.contains(".")) {
            String[] arr = tableName.split("\\.");
            tableName = arr[1];
            schema = arr[0];
        }
        if (schema == null) {
            schema = DEFAULT_PG_SCHEMA;
        }
        if (isCaseSensitive.booleanValue()) {
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
        this.tableName = tableName;
        this.schema = schema;
    }

    protected String getRemarks(ResultSet columns) throws SQLException {
        return columns.getString("REMARKS");
    }

    protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
        ResultSet columns = dbmd.getColumns(this.cataLog, this.schema, this.tableName.replace("\"", ""), null);
        return columns;
    }

    protected IColumn createColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, String defaultValue, String remarks) {
        PostgresColumn column = new PostgresColumn(columnName, columnSize.intValue(), digits.intValue(), columnTypeName, nullable.booleanValue(), defaultValue, remarks, this.dialect);
        return column;
    }

    protected Object[] getSpatialInfo(String colunmName) throws SQLException {
        Constants.GEO_TYPE[] values;
        String sql = "select srid,type from geometry_columns where f_table_catalog = ? and f_table_schema = ? and f_table_name = ? and f_geometry_column = ?";
        List i = this.genericDao.queryBySql(sql, new Object[]{this.cataLog, this.schema, this.tableName, colunmName}, null, null, null, null, null, IJDBCTransformer.MAP);
        if (i.isEmpty()) {
            return null;
        }
        Map data = (Map)i.get(0);
        Integer srid = (Integer)data.get("srid");
        String type = (String)data.get("type");
        Constants.GEO_TYPE gtype = Constants.GEO_TYPE.GEOMETRY;
        for (Constants.GEO_TYPE geo_type : values = Constants.GEO_TYPE.values()) {
            if (!geo_type.name().equalsIgnoreCase(type)) continue;
            gtype = geo_type;
        }
        return new Object[]{srid, gtype};
    }

    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        String indexName = this.createSpatialIndexName(colname);
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + "_" + colname + "\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15");
            String indexName1 = indexName;
            String tableName = this.tableName;
            String colname1 = colname;
            if (this.dialect.markForTableNameAndColumnName().booleanValue()) {
                tableName = "\"" + tableName + "\"";
                indexName1 = "\"" + indexName1 + "\"";
                colname1 = "\"" + colname1 + "\"";
            }
            String sql = "CREATE INDEX " + indexName1 + " ON " + tableName + "USING gist (" + colname1 + ");";
            this.genericDao.doExecuteSql(sql, null, null);
            Index index = new Index();
            index.setName(indexName);
            index.setUnique(Boolean.valueOf(false));
            index.isSpatial(Boolean.valueOf(true));
            index.setColname(colname);
            this.addToIndexMap(colname, (IIndex)index);
            return null;
        });
        return promise;
    }
}

