/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.resources;

import com.geoway.vtile.resources.MongodbDao;
import com.geoway.vtile.resources.MongodbDaoImpl;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongodbFactory {
    protected MongoDatabase mongoDatabase = null;
    protected MongoClient client = null;

    public MongodbFactory(MongoClient mongoClient, String databaseName) {
        this.client = mongoClient;
        this.mongoDatabase = mongoClient.getDatabase(databaseName);
    }

    public MongodbDao getDao(String tableName) {
        return new MongodbDaoImpl(this.mongoDatabase, tableName);
    }

    public MongoCollection getCollection(String tableName) {
        return this.mongoDatabase.getCollection(tableName);
    }

    public Boolean collectionExist(String collectionName) {
        MongoIterable it = this.mongoDatabase.listCollectionNames();
        for (String name : it) {
            if (!collectionName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void createCollection(String collectionName, CreateCollectionOptions options) {
        this.mongoDatabase.createCollection(collectionName, options);
    }

    public void dropCollection(String tableName) {
        MongoCollection collection = this.getCollection(tableName);
        if (collection != null) {
            collection.drop();
        }
    }

    public void renameCollection(String tableName, String newName) {
        boolean isExists = this.collectionExist(newName);
        if (isExists) {
            throw new RuntimeException(newName + "\u96c6\u5408\u5df2\u7ecf\u5b58\u5728");
        }
        boolean isOldExists = this.collectionExist(tableName);
        if (!isOldExists) {
            return;
        }
        MongoCollection collection = this.getCollection(tableName);
        MongoNamespace namespace = new MongoNamespace(collection.getNamespace().getDatabaseName(), newName);
        collection.renameCollection(namespace);
    }

    public void setDBSharding() {
        MongoDatabase adminDB = this.client.getDatabase("admin");
        String thisdbName = this.mongoDatabase.getName();
        Document ret = adminDB.runCommand((Bson)new Document("enableSharding", (Object)thisdbName));
    }

    public void shardCollectionHashed(String collectionName, String hashKeyField) {
        MongoDatabase adminDB = this.client.getDatabase("admin");
        String thisdbName = this.mongoDatabase.getName();
        String nsName = thisdbName + "." + collectionName;
        MongoCollection collection = this.getCollection(collectionName);
        collection.createIndex(Indexes.hashed((String)hashKeyField));
        Document shardCmd = new Document("shardCollection", (Object)nsName);
        Document hashKey = new Document(hashKeyField, (Object)"hashed");
        shardCmd.put("key", (Object)hashKey);
        Document ret = adminDB.runCommand((Bson)shardCmd);
    }
}

