/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.vtile.tiledispatch.task.task;

import com.geoway.vtile.diagnose.Log4jUtil;
import com.geoway.vtile.model.vector_service.ICacheable;
import com.geoway.vtile.model.vector_service.IVectorService;
import com.geoway.vtile.model.vector_service.VectorServiceBean;
import com.geoway.vtile.model.vector_service.storage.IStorageInfo;
import com.geoway.vtile.model.vector_service.storage.StorageInfoBean;
import com.geoway.vtile.model.vector_service.storage.StorageInfoShell;
import com.geoway.vtile.resources.datasource.MongodbDataSource;
import com.geoway.vtile.spatial.grid.Constants;
import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.tiledispatch.consumer.ITileConsumer;
import com.geoway.vtile.tiledispatch.consumer.VectorCutMongoConsumer;
import com.geoway.vtile.tiledispatch.consumer.handler.TileListCutHandler;
import com.geoway.vtile.tiledispatch.consumer.saver.MongoTileSaver;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.saver.endocer.TileLayoutDocumentEncoder;
import com.geoway.vtile.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.geoway.vtile.tiledispatch.executor.DoubleQueueExecutor;
import com.geoway.vtile.tiledispatch.producer.ITileProducer;
import com.geoway.vtile.tiledispatch.producer.TileLayoutProducer;
import com.geoway.vtile.tiledispatch.task.TileDispatchTaskManager;
import com.geoway.vtile.tiledispatch.task.stage.TileConsumeStage;
import com.geoway.vtile.tiledispatch.task.stage.TileProduceStage;
import com.geoway.vtile.tiledispatch.task.stage.abstractclass.AbstractTaskStage;
import com.geoway.vtile.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.geoway.vtile.transform.cell.ITileCutterCell;
import com.geoway.vtile.transform.cell.ServerTileCutterCell;
import com.geoway.vtile.transform.cell.layout.ITileLayoutPrecutter;
import com.geoway.vtile.transform.cell.layout.MapTilePrecutter;
import com.geoway.vtile.transform.cell.process.ProcessList;
import com.geoway.vtile.transform.enums.LAYER_TYPE;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileServerCutTask
extends AbstractTileDispatchTask {
    private static Logger logger = LoggerFactory.getLogger(TileServerCutTask.class);
    IVectorService vectorService;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    LAYER_TYPE layerType = LAYER_TYPE.layer;
    public static final int CUT_INTERVAL = 2;
    Integer taskNum;
    ExecutorService cutExecutor;

    public TileServerCutTask(String name, IVectorService vectorService, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, String bbox) {
        this(name, vectorService, grid, dataSource, beginLevel, endLevel);
        this.bbox = bbox;
    }

    public TileServerCutTask(String name, IVectorService vectorService, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel) {
        super(name);
        this.vectorService = vectorService;
        this.grid = grid;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.layerType = this.layerType;
        this.mongodbDataSource = dataSource;
        this.bbox = vectorService.getBbox();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        int taskNum = Runtime.getRuntime().availableProcessors();
        if (this.executor == null) {
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        this.cutExecutor = new DoubleQueueExecutor(nThreads);
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u521d\u59cb\u5316\u5730\u56fe\u77e2\u91cf\u74e6\u7247\u9884\u70ed\u4efb\u52a1: {}, \u5c42\u7ea7\u8303\u56f4: {}~{}, \u74e6\u7247\u9884\u70ed\u7ebf\u7a0b\u6c60\u5927\u5c0f: {}", new Object[]{this.name, this.beginLevel, this.endLevel, nThreads});
        }
        if (this.vectorService.getGridTree().getUnit().equals((Object)Constants.GRID_UNIT.meter) && StringUtils.isBlank((CharSequence)this.bbox) && StringUtils.isNotBlank((CharSequence)((VectorServiceBean)this.vectorService.getBean()).getBbox())) {
            this.bbox = ((VectorServiceBean)this.vectorService.getBean()).getBbox();
        }
        this.buildStages();
        IStorageInfo storageInfo = this.createStorageInfo();
        this.vectorService.addStorageInfo(storageInfo);
        try {
            this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private MongoTileSaver createTileSaver() {
        IStorageInfo storageInfo;
        if (!this.resume && (storageInfo = this.vectorService.getStorageInfo()) != null) {
            storageInfo.drop();
        }
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), (String)this.vectorService.getId());
        tileSaver.setEnableSharding(true);
        tileSaver.init();
        return tileSaver;
    }

    @Override
    public void success() throws Exception {
        IStorageInfo storageInfo = this.vectorService.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            this.vectorService.getClient().getVectorServiceManager().update((Object)this.vectorService);
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u670d\u52a1\u5143\u6570\u636ecompleted\u72b6\u6001\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        ICacheable cacheable = this.vectorService.getCacheInfo();
        if (cacheable != null && !this.resume) {
            cacheable.drop((String)this.vectorService.getId(), null);
        }
        super.success();
    }

    private IStorageInfo createStorageInfo() {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName((String)this.vectorService.getId());
        storageInfoBean.setCompleted(false);
        return new StorageInfoShell(this.vectorService.getClient(), storageInfoBean);
    }

    private void buildStages() {
        this.stages = new ArrayList();
        int interval = this.beginLevel <= 10 ? 0 : 2;
        int end = this.beginLevel;
        int start = this.beginLevel;
        while (start <= this.endLevel) {
            int n = end = start + interval < this.endLevel ? start + interval : this.endLevel;
            if (this.endLevel - end <= 2) {
                end = this.endLevel;
            }
            int startLevel = start;
            if (end >= 10) {
                interval = 2;
            }
            if (Log4jUtil.isDiagnoseEnable()) {
                if (end > start) {
                    logger.info("\u74e6\u7247\u9884\u70ed\u5b50\u4efb\u52a1\u5c42\u7ea7\u533a\u95f4\uff1a{}~{}", (Object)start, (Object)end);
                } else {
                    logger.info("\u74e6\u7247\u9884\u70ed\u5b50\u4efb\u52a1\u5c42\u7ea7\u533a\u95f4\uff1a{}", (Object)start);
                }
            }
            String produceStageName = "\u9884\u5236" + start + "\u7ea7\u5730\u56fe\u670d\u52a1\u74e6\u7247\u6846\u67b6";
            MapTilePrecutter cell = new MapTilePrecutter(this.vectorService, this.cutExecutor);
            cell.setMainLevel(Integer.valueOf(start));
            cell.setDown(end - start);
            ITileProducer producer = this.createProducer(start, end, cell);
            AbstractTaskStage stage = new TileProduceStage(produceStageName, producer, start, end);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            logger.info("\u5df2\u6dfb\u52a0\u9636\u6bb5>>> " + produceStageName);
            String consumeStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u5730\u56fe\u670d\u52a1\u74e6\u7247";
            Integer filterLevel = null;
            if (!cell.isSameFilter()) {
                filterLevel = start;
            }
            ITileConsumer tileConsumer = this.createConsumer(start, end, filterLevel);
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            logger.info("\u5df2\u6dfb\u52a0\u9636\u6bb5>>> " + consumeStageName);
            start = end + 1;
        }
        logger.info("\u5df2\u5b8c\u6210\u74e6\u7247\u9884\u70ed\u4efb\u52a1\u89c4\u5212");
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u74e6\u7247\u9884\u70ed\u5b50\u533a\u6bb5\u4e2a\u6570\uff1a{}\uff0c\u5b50\u4efb\u52a1\u5217\u8868\u5982\u4e0b\uff1a\n {} ", (Object)this.stages.size(), (Object)StringUtils.join(this.stages.stream().map(sta -> sta.getName()).iterator(), (String)"\n "));
        }
    }

    private ITileProducer createProducer(int beginLevel, int endLevel, MapTilePrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer((ITileLayoutPrecutter)cell, this.saver, this.executor, beginLevel, endLevel, this.grid, this.bbox, (String)this.vectorService.getId(), new TileLayoutDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private ITileConsumer createConsumer(int start, int end, Integer filterLevel) {
        ServerTileCutterCell cutterCell = new ServerTileCutterCell(this.vectorService, this.cutExecutor);
        cutterCell.setMainLevel(Integer.valueOf(start));
        cutterCell.setDown(end - start);
        TileListCutHandler handlerStream = new TileListCutHandler(this.executor, 1, (ITileCutterCell)cutterCell, this.saver, new TileDataDocumentEncoder());
        handlerStream.setLogger(this.cutLogger);
        handlerStream.setResume(this.resume);
        TileLayoutScroll scroll = new TileLayoutScroll(start, this.grid, this.saver, filterLevel, true);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    @Override
    public void release() {
        if (null != this.cutExecutor && !this.cutExecutor.isShutdown()) {
            this.cutExecutor.shutdown();
        }
        ProcessList.clearCache();
        logger.info("\u4efb\u52a1\u7f13\u5b58\u5df2\u6e05\u7406");
        super.release();
    }
}

